/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.chat;

import com.google.common.collect.Lists;
import com.samskivert.swing.Label;
import com.samskivert.swing.util.SwingUtil;
import com.threerings.NenyaLog;
import com.threerings.chat.ChatGlyph;
import com.threerings.chat.ChatLogic;
import com.threerings.chat.ChatOverlay;
import com.threerings.chat.SubtitleChatOverlay;
import com.threerings.crowd.chat.data.ChatMessage;
import com.threerings.crowd.chat.data.UserMessage;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.media.image.ColorUtil;
import com.threerings.util.MessageBundle;
import com.threerings.util.Name;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JScrollBar;

public class ComicChatOverlay
extends SubtitleChatOverlay {
    protected int _newPlacePoint = 0;
    protected List<BubbleGlyph> _bubbles = Lists.newArrayList();
    protected static final int MINIMUM_SPLIT_WIDTH = 90;
    protected static final double GOLDEN;
    protected static final int BUBBLE_SPACING = 15;
    protected static final int SPEAKER_DISTANCE = 20;
    protected static final int TAIL_WIDTH = 12;
    protected static final int MAX_BUBBLES = 8;
    protected static final int MAX_BUBBLES_PER_USER = 3;
    protected static final Color[] BACKGROUNDS;

    public ComicChatOverlay(CrowdContext ctx, ChatLogic logic, JScrollBar historyBar, int subtitleHeight) {
        super(ctx, logic, historyBar, subtitleHeight);
    }

    @Override
    public void newPlaceEntered(ChatOverlay.InfoProvider provider) {
        this._newPlacePoint = this._ctx.getChatDirector().getHistory().size();
        super.newPlaceEntered(provider);
        this.clearBubbles(false);
    }

    @Override
    public void layout() {
        this.clearBubbles(true);
        super.layout();
    }

    @Override
    public void removed() {
        this.clearBubbles(true);
        super.removed();
    }

    @Override
    public void clear() {
        super.clear();
        this.clearBubbles(true);
    }

    @Override
    public void viewDidScroll(int dx, int dy) {
        super.viewDidScroll(dx, dy);
        this.viewDidScroll(this._bubbles, dx, dy);
    }

    @Override
    public void setDimmed(boolean dimmed) {
        super.setDimmed(dimmed);
        this.updateDimmed(this._bubbles);
    }

    @Override
    public void speakerDeparted(Name speaker) {
        Iterator<BubbleGlyph> iter = this._bubbles.iterator();
        while (iter.hasNext()) {
            BubbleGlyph rec = iter.next();
            if (!rec.isSpeaker(speaker)) continue;
            this._target.abortAnimation(rec);
            iter.remove();
        }
    }

    @Override
    public void historyUpdated(int adjustment) {
        this._newPlacePoint -= adjustment;
        super.historyUpdated(adjustment);
    }

    protected void clearBubbles(boolean all) {
        Iterator<BubbleGlyph> iter = this._bubbles.iterator();
        while (iter.hasNext()) {
            ChatGlyph rec = iter.next();
            if (!all && !this.isPlaceOrientedType(rec.getType())) continue;
            this._target.abortAnimation(rec);
            iter.remove();
        }
    }

    @Override
    protected boolean shouldShowFromHistory(ChatMessage msg, int index) {
        return index >= this._newPlacePoint || !this.isPlaceOrientedType(this.getType(msg, false));
    }

    @Override
    protected boolean isApprovedLocalType(String localtype) {
        if ("placeChat".equals(localtype) || "userChat".equals(localtype)) {
            return true;
        }
        NenyaLog.log.debug((Object)"Ignoring non-standard system/feedback chat", new Object[]{"localtype", localtype});
        return false;
    }

    protected boolean isPlaceOrientedType(int type) {
        return ChatLogic.placeOf(type) == 16;
    }

    @Override
    protected void displayMessage(ChatMessage message, int type, Graphics2D layoutGfx) {
        String text = message.message;
        switch (ChatLogic.placeOf(type)) {
            case 112: 
            case 144: {
                if (!this.createBubble(layoutGfx, type, message.timestamp, text, null, null)) break;
                return;
            }
            case 16: {
                UserMessage msg = (UserMessage)message;
                Point speakerloc = this._provider.getSpeaker(msg.speaker);
                if (speakerloc == null) {
                    NenyaLog.log.warning((Object)"ChatOverlay.InfoProvider doesn't know the speaker!", new Object[]{"speaker", msg.speaker, "type", type});
                    return;
                }
                if (ChatLogic.modeOf(type) == 2) {
                    text = this.xlate(MessageBundle.tcompose((String)"m.emote_format", (Object)msg.getSpeakerDisplayName())) + " " + text;
                }
                String leftover = text;
                for (int ii = 1; ii < 7; ++ii) {
                    String bubtext = this.splitNear(text, text.length() / ii);
                    if (!this.createBubble(layoutGfx, type, msg.timestamp, bubtext + (ii > 1 ? "..." : ""), msg.speaker, speakerloc)) continue;
                    leftover = text.substring(bubtext.length());
                    break;
                }
                if (leftover.length() > 0 && !this.isHistoryMode()) {
                    String ltext = MessageBundle.tcompose((String)"m.continue_format", (Object)msg.speaker);
                    ltext = this.xlate(ltext) + " \"" + leftover + "\"";
                    this.addSubtitle(this.createSubtitle(layoutGfx, 160, message.timestamp, null, 0, ltext, true));
                }
                return;
            }
        }
        super.displayMessage(message, type, layoutGfx);
    }

    protected String splitNear(String text, int pos) {
        int newpos;
        if (pos >= text.length()) {
            return text;
        }
        int forward = text.indexOf(32, pos);
        int backward = text.lastIndexOf(32, pos);
        int n = newpos = Math.abs(pos - forward) < Math.abs(pos - backward) ? forward : backward;
        newpos = newpos == -1 ? pos : ++newpos;
        return text.substring(0, newpos);
    }

    protected boolean createBubble(Graphics2D gfx, int type, long timestamp, String text, Name speaker, Point speakerloc) {
        Shape shape;
        Rectangle placer;
        Label label = this.layoutText(gfx, this._logic.getFont(type), text);
        label.setAlignment(0);
        gfx.dispose();
        Rectangle r = this.getBubbleSize(type, label.getSize());
        List<BubbleGlyph> oldbubs = this.getAndExpireBubbles(speaker);
        int numold = oldbubs.size();
        Rectangle bigR = null;
        if (numold == 0) {
            placer = new Rectangle(r);
            this.positionRectIdeally(placer, type, speakerloc);
        } else {
            bigR = this.getRectWithOlds(r, oldbubs);
            placer = new Rectangle(bigR);
            this.positionRectIdeally(placer, type, speakerloc);
            placer.setLocation((placer.x + bigR.x) / 2, (placer.y + (bigR.y - r.height / 2)) / 2);
        }
        Rectangle vbounds = new Rectangle(this._target.getViewBounds());
        vbounds.height -= this._subtitleHeight;
        if (!SwingUtil.positionRect((Rectangle)placer, (Rectangle)vbounds, this.getAvoidList(speaker))) {
            return false;
        }
        if (0 == numold) {
            r.setLocation(placer.x, placer.y);
        } else {
            int dx = placer.x - bigR.x;
            int dy = placer.y - bigR.y;
            for (int ii = 0; ii < numold; ++ii) {
                BubbleGlyph bub = oldbubs.get(ii);
                bub.removeTail();
                Rectangle ob = bub.getBubbleBounds();
                int xadjust = dx - (ob.x - bigR.x) + (placer.width - ob.width) / 2;
                bub.translate(xadjust, dy);
            }
            r.setLocation(placer.x + (placer.width - r.width) / 2, placer.y + placer.height - r.height);
        }
        Shape full = shape = this.getBubbleShape(type, r);
        if (speakerloc != null) {
            Area area = new Area(this.getTail(type, r, speakerloc));
            area.add(new Area(shape));
            full = area;
        }
        long lifetime = this.getChatExpire(timestamp, label.getText()) - timestamp;
        BubbleGlyph newbub = new BubbleGlyph(this, type, lifetime, full, label, this.adjustLabel(type, r.getLocation()), shape, speaker, this._logic.getOutlineColor(type));
        newbub.setDim(this._dimmed);
        this._bubbles.add(newbub);
        this._target.addAnimation(newbub);
        int numbubs = this._bubbles.size();
        for (int ii = 0; ii < numbubs; ++ii) {
            this._bubbles.get(ii).setAgeLevel(numbubs - ii - 1);
        }
        return true;
    }

    protected Rectangle getBubbleSize(int type, Dimension d) {
        switch (ChatLogic.modeOf(type)) {
            case 1: 
            case 2: 
            case 3: {
                return new Rectangle(d.width + 40, d.height + 40);
            }
        }
        return new Rectangle(d.width + 20, d.height + 20);
    }

    protected Point adjustLabel(int type, Point labelpos) {
        switch (ChatLogic.modeOf(type)) {
            case 1: 
            case 2: 
            case 3: {
                labelpos.translate(20, 20);
                break;
            }
            default: {
                labelpos.translate(10, 10);
            }
        }
        return labelpos;
    }

    protected void positionRectIdeally(Rectangle r, int type, Point speaker) {
        if (speaker != null) {
            r.setLocation(speaker.x - r.width / 2, speaker.y - r.height / 2);
            return;
        }
        Rectangle vbounds = this._target.getViewBounds();
        switch (ChatLogic.placeOf(type)) {
            case 112: 
            case 144: {
                r.setLocation(vbounds.x + 15, vbounds.y + 15);
                return;
            }
            case 16: {
                NenyaLog.log.warning((Object)"Got to a place where I shouldn't get!", new Object[0]);
            }
        }
        NenyaLog.log.debug((Object)"Unhandled chat type in getLocation()", new Object[]{"type", type});
        r.setLocation((vbounds.width - r.width) / 2, (vbounds.height - r.height) / 2);
    }

    protected Rectangle getRectWithOlds(Rectangle r, List<BubbleGlyph> oldbubs) {
        int n = oldbubs.size();
        if (n == 0) {
            return r;
        }
        Rectangle bigR = null;
        for (int ii = 0; ii < n; ++ii) {
            BubbleGlyph bub = oldbubs.get(ii);
            bigR = ii == 0 ? bub.getBubbleBounds() : bigR.union(bub.getBubbleBounds());
        }
        bigR.width = Math.max(bigR.width, r.width);
        bigR.height += r.height;
        return bigR;
    }

    protected Shape getBubbleShape(int type, Rectangle r) {
        switch (ChatLogic.placeOf(type)) {
            case 112: 
            case 144: {
                return new Area(r);
            }
        }
        switch (ChatLogic.modeOf(type)) {
            case 0: {
                return new Area(new RoundRectangle2D.Float(r.x, r.y, r.width, r.height, 40.0f, 40.0f));
            }
            case 1: {
                Polygon left = new Polygon();
                Polygon right = new Polygon();
                Polygon top = new Polygon();
                Polygon bot = new Polygon();
                int x = r.x + 10;
                int y = r.y + 10;
                int wid = r.width - 20;
                int hei = r.height - 20;
                Area a = new Area(new Rectangle(x, y, wid, hei));
                int spikebase = 10;
                int cornbase = spikebase * 3 / 4;
                left.addPoint(x, y);
                left.addPoint(x - 10, y + spikebase / 2);
                left.addPoint(x, y + spikebase);
                right.addPoint(x + wid, y);
                right.addPoint(x + wid + 10, y + spikebase / 2);
                right.addPoint(x + wid, y + spikebase);
                int ypos = 0;
                int ahei = hei - cornbase;
                int maxpos = ahei - spikebase + 1;
                int numvert = (int)Math.ceil((float)ahei / (float)spikebase);
                for (int ii = 0; ii < numvert; ++ii) {
                    int newpos = cornbase / 2 + Math.min(ahei * ii / numvert, maxpos);
                    left.translate(0, newpos - ypos);
                    right.translate(0, newpos - ypos);
                    a.add(new Area(left));
                    a.add(new Area(right));
                    ypos = newpos;
                }
                top.addPoint(x, y);
                top.addPoint(x + spikebase / 2, y - 10);
                top.addPoint(x + spikebase, y);
                bot.addPoint(x, y + hei);
                bot.addPoint(x + spikebase / 2, y + hei + 10);
                bot.addPoint(x + spikebase, y + hei);
                int xpos = 0;
                int awid = wid - cornbase;
                maxpos = awid - spikebase + 1;
                int numhorz = (int)Math.ceil((float)awid / (float)spikebase);
                for (int ii = 0; ii < numhorz; ++ii) {
                    int newpos = cornbase / 2 + Math.min(awid * ii / numhorz, maxpos);
                    top.translate(newpos - xpos, 0);
                    bot.translate(newpos - xpos, 0);
                    a.add(new Area(top));
                    a.add(new Area(bot));
                    xpos = newpos;
                }
                Polygon corner = new Polygon();
                corner.addPoint(x, y + cornbase);
                corner.addPoint(x - 10 + 2, y - 10 + 2);
                corner.addPoint(x + cornbase, y);
                a.add(new Area(corner));
                corner.reset();
                corner.addPoint(x + wid - cornbase, y);
                corner.addPoint(x + wid + 10 - 2, y - 10 + 2);
                corner.addPoint(x + wid, y + cornbase);
                a.add(new Area(corner));
                corner.reset();
                corner.addPoint(x + wid, y + hei - cornbase);
                corner.addPoint(x + wid + 10 - 2, y + hei + 10 - 2);
                corner.addPoint(x + wid - cornbase, y + hei);
                a.add(new Area(corner));
                corner.reset();
                corner.addPoint(x + cornbase, y + hei);
                corner.addPoint(x - 10 + 2, y + hei + 10 - 2);
                corner.addPoint(x, y + hei - cornbase);
                a.add(new Area(corner));
                return a;
            }
            case 2: {
                Area a = new Area(r);
                a.subtract(new Area(new Ellipse2D.Float(r.x, r.y - 10, r.width, 20.0f)));
                a.subtract(new Area(new Ellipse2D.Float(r.x, r.y + r.height - 10, r.width, 20.0f)));
                a.subtract(new Area(new Ellipse2D.Float(r.x - 10, r.y, 20.0f, r.height)));
                a.subtract(new Area(new Ellipse2D.Float(r.x + r.width - 10, r.y, 20.0f, r.height)));
                return a;
            }
            case 3: {
                int x = r.x + 10;
                int y = r.y + 10;
                int wid = r.width - 20;
                int hei = r.height - 20;
                Area a = new Area(new Rectangle(x, y, wid, hei));
                int dia = 12;
                int numvert = (int)Math.ceil((float)hei / (float)dia);
                int leftside = x - dia / 2;
                int rightside = x + wid - dia / 2 - 1;
                int maxh = hei - dia;
                for (int ii = 0; ii < numvert; ++ii) {
                    int ypos = y + Math.min(hei * ii / numvert, maxh);
                    a.add(new Area(new Ellipse2D.Float(leftside, ypos, dia, dia)));
                    a.add(new Area(new Ellipse2D.Float(rightside, ypos, dia, dia)));
                }
                dia = 16;
                int numhorz = (int)Math.ceil((float)wid / (float)dia);
                int topside = y - dia / 3;
                int botside = y + hei - dia / 3 - 1;
                int maxw = wid - dia;
                for (int ii = 0; ii < numhorz; ++ii) {
                    int xpos = x + Math.min(wid * ii / numhorz, maxw);
                    a.add(new Area(new Ellipse2D.Float(xpos, topside, dia, dia * 2 / 3)));
                    a.add(new Area(new Ellipse2D.Float(xpos, botside, dia, dia * 2 / 3)));
                }
                return a;
            }
        }
        return this._logic.getSubtitleShape(type, r, r);
    }

    protected Shape getTail(int type, Rectangle r, Point speaker) {
        if (ChatLogic.modeOf(type) == 2) {
            return new Area();
        }
        int midx = r.x + r.width / 2;
        int midy = r.y + r.height / 2;
        int xx = speaker.x - midx;
        int yy = speaker.y - midy;
        float dist = (float)Math.sqrt(xx * xx + yy * yy);
        float perc = (dist - 20.0f) / dist;
        if (ChatLogic.modeOf(type) == 3) {
            int steps = Math.max((int)(dist / 20.0f), 2);
            float step = perc / (float)steps;
            Area a = new Area();
            int ii = 0;
            while (ii < steps) {
                int radius = Math.min(9, ii + 2);
                a.add(new Area(new Ellipse2D.Float((float)((int)((1.0f - perc) * (float)midx + perc * (float)speaker.x)) + perc * (float)radius, (float)((int)((1.0f - perc) * (float)midy + perc * (float)speaker.y)) + perc * (float)radius, radius * 2, radius * 2)));
                ++ii;
                perc -= step;
            }
            return a;
        }
        Polygon p = new Polygon();
        p.addPoint((int)((1.0f - perc) * (float)midx + perc * (float)speaker.x), (int)((1.0f - perc) * (float)midy + perc * (float)speaker.y));
        if (Math.abs(speaker.x - midx) > Math.abs(speaker.y - midy)) {
            int x = midx > speaker.x ? r.x + 10 : r.x + r.width - 10;
            p.addPoint(x, midy - 6);
            p.addPoint(x, midy + 6);
        } else {
            int y = midy > speaker.y ? r.y + 10 : r.y + r.height - 10;
            p.addPoint(midx - 6, y);
            p.addPoint(midx + 6, y);
        }
        return p;
    }

    protected List<BubbleGlyph> getAndExpireBubbles(Name speaker) {
        int num = this._bubbles.size();
        ArrayList oldbubs = Lists.newArrayList();
        if (speaker != null) {
            for (int ii = 0; ii < num; ++ii) {
                BubbleGlyph bub = this._bubbles.get(ii);
                if (!bub.isSpeaker(speaker)) continue;
                oldbubs.add(bub);
            }
        }
        if (oldbubs.size() >= 3) {
            BubbleGlyph bub = (BubbleGlyph)oldbubs.remove(0);
            this._bubbles.remove(bub);
            this._target.abortAnimation(bub);
        } else if (num >= 8) {
            this._target.abortAnimation(this._bubbles.remove(0));
        }
        return oldbubs;
    }

    @Override
    protected void glyphExpired(ChatGlyph glyph) {
        super.glyphExpired(glyph);
        this._bubbles.remove(glyph);
    }

    protected Label layoutText(Graphics2D gfx, Font font, String text) {
        int targetheight;
        Label label = this._logic.createLabel(text);
        label.setFont(font);
        Rectangle vbounds = this._target.getViewBounds();
        label.setTargetWidth(vbounds.width - 20);
        label.layout(gfx);
        Dimension d = label.getSize();
        if (d.width > 90 && (targetheight = this.getGoldenLabelHeight(d)) > 1) {
            label.setTargetHeight(targetheight * d.height);
            label.layout(gfx);
        }
        return label;
    }

    protected int getGoldenLabelHeight(Dimension d) {
        double lastratio = ((double)d.width + 20.0) / ((double)d.height + 20.0);
        int lines = 2;
        double ratio;
        while (Math.abs((ratio = ((double)(d.width / lines) + 20.0) / ((double)(d.height * lines) + 20.0)) - GOLDEN) < Math.abs(lastratio - GOLDEN)) {
            lastratio = ratio;
            ++lines;
        }
        return lines - 1;
    }

    protected List<Shape> getAvoidList(Name speaker) {
        ArrayList avoid = Lists.newArrayList();
        if (this._provider == null) {
            return avoid;
        }
        this._provider.getAvoidables(speaker, avoid, null);
        for (BubbleGlyph bub : this._bubbles) {
            if (bub.isSpeaker(speaker)) continue;
            avoid.add(bub.getBubbleTerritory());
        }
        return avoid;
    }

    @Override
    protected int getDisplayDurationOffset() {
        return 0;
    }

    static {
        int ii;
        GOLDEN = (1.0 + Math.sqrt(5.0)) / 2.0;
        BACKGROUNDS = new Color[8];
        Color yellowy = new Color(221, 221, 106);
        Color blackish = new Color(0xCCCCCC);
        float steps = 3.0f;
        for (ii = 0; ii < 4; ++ii) {
            ComicChatOverlay.BACKGROUNDS[ii] = ColorUtil.blend(Color.white, yellowy, (steps - (float)ii) / steps);
        }
        for (ii = 4; ii < 8; ++ii) {
            ComicChatOverlay.BACKGROUNDS[ii] = ColorUtil.blend(blackish, yellowy, ((float)ii - steps) / steps);
        }
    }

    protected static class BubbleGlyph
    extends ChatGlyph {
        protected Shape _sansTail;
        protected Name _speaker;
        protected int _agelevel = 0;

        public BubbleGlyph(SubtitleChatOverlay owner, int type, long lifetime, Shape shape, Label label, Point labelpos, Shape sansTail, Name speaker, Color outline) {
            super(owner, type, lifetime, shape.getBounds(), shape, null, null, label, labelpos, outline);
            this._sansTail = sansTail;
            this._speaker = speaker;
        }

        public void setAgeLevel(int agelevel) {
            this._agelevel = agelevel;
            this.invalidate();
        }

        @Override
        public void viewDidScroll(int dx, int dy) {
            if (this._type == 112 || this._type == 144) {
                this.translate(dx, dy);
            }
        }

        @Override
        protected Color getBackground() {
            if (this._background == Color.WHITE) {
                return BACKGROUNDS[this._agelevel];
            }
            return this._background;
        }

        public Shape getBubbleTerritory() {
            Rectangle bounds = this.getBubbleBounds();
            bounds.grow(15, 15);
            return bounds;
        }

        public Rectangle getBubbleBounds() {
            return this._sansTail.getBounds();
        }

        public boolean isSpeaker(Name player) {
            return this._speaker != null && this._speaker.equals((Object)player);
        }

        public void removeTail() {
            this.invalidate();
            this._shape = this._sansTail;
            this._bounds = this._shape.getBounds();
            this.jiggleBounds();
            this.invalidate();
        }
    }
}

