/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast.util;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.samskivert.util.RandomUtil;
import com.threerings.cast.CharacterDescriptor;
import com.threerings.cast.ComponentClass;
import com.threerings.cast.ComponentRepository;
import com.threerings.cast.Log;
import com.threerings.media.image.ColorPository;
import com.threerings.media.image.Colorization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class CastUtil {
    public static CharacterDescriptor getRandomDescriptor(ComponentRepository crepo, String gender, String[] COMP_CLASSES, ColorPository cpos, String[] COLOR_CLASSES) {
        ArrayList classes = Lists.newArrayList();
        for (String element : COMP_CLASSES) {
            String cname = gender + "/" + element;
            ComponentClass cclass = crepo.getComponentClass(cname);
            if (cclass == null) {
                Log.log.warning((Object)"Missing definition for component class", new Object[]{"class", cname});
                continue;
            }
            Iterator<Integer> iter = crepo.enumerateComponentIds(cclass);
            if (!iter.hasNext()) {
                Log.log.info((Object)"Skipping class for which we have no components", new Object[]{"class", cclass});
                continue;
            }
            classes.add(cclass);
        }
        int[] components = new int[classes.size()];
        Colorization[][] zations = new Colorization[components.length][];
        for (int ii = 0; ii < components.length; ++ii) {
            ComponentClass cclass = (ComponentClass)classes.get(ii);
            ArrayList choices = Lists.newArrayList();
            Iterators.addAll((Collection)choices, crepo.enumerateComponentIds(cclass));
            zations[ii] = new Colorization[COLOR_CLASSES.length];
            for (int zz = 0; zz < COLOR_CLASSES.length; ++zz) {
                zations[ii][zz] = cpos.getRandomStartingColor(COLOR_CLASSES[zz]).getColorization();
            }
            if (choices.size() > 0) {
                int idx = RandomUtil.getInt((int)choices.size());
                components[ii] = (Integer)choices.get(idx);
                continue;
            }
            Log.log.info((Object)"Have no components in class", new Object[]{"class", cclass});
        }
        return new CharacterDescriptor(components, zations);
    }
}

