/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.threerings.openal.SoundManager;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.Util;

public class Buffer {
    private IntBuffer _idbuf;
    protected SoundManager _soundmgr;
    protected int _id;

    public Buffer(SoundManager soundmgr) {
        this._soundmgr = soundmgr;
        this._idbuf = BufferUtils.createIntBuffer((int)1);
        AL10.alGenBuffers((IntBuffer)this._idbuf);
        this._id = this._idbuf.get(0);
    }

    public final int getId() {
        return this._id;
    }

    public void setData(int format, ByteBuffer data, int frequency) {
        AL10.alBufferData((int)this._id, (int)format, (ByteBuffer)data, (int)frequency);
        Util.checkALError();
    }

    public void setData(int format, IntBuffer data, int frequency) {
        AL10.alBufferData((int)this._id, (int)format, (IntBuffer)data, (int)frequency);
        Util.checkALError();
    }

    public void setData(int format, ShortBuffer data, int frequency) {
        AL10.alBufferData((int)this._id, (int)format, (ShortBuffer)data, (int)frequency);
        Util.checkALError();
    }

    public int getSize() {
        return AL10.alGetBufferi((int)this._id, (int)8196);
    }

    public void delete() {
        this._idbuf.rewind();
        AL10.alDeleteBuffers((IntBuffer)this._idbuf);
        this._id = 0;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._id > 0) {
            this._soundmgr.bufferFinalized(this._id);
        }
    }
}

