/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.sprite;

import com.samskivert.swing.Label;
import com.samskivert.swing.util.SwingUtil;
import com.threerings.media.sprite.Sprite;
import com.threerings.media.sprite.action.ArmingSprite;
import com.threerings.media.sprite.action.CommandSprite;
import com.threerings.media.sprite.action.DisableableSprite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;

public class ButtonSprite
extends Sprite
implements CommandSprite,
ArmingSprite,
DisableableSprite {
    public static final int NORMAL = 0;
    public static final int ROUNDED = 1;
    protected static final int PADDING = 2;
    protected Label _label;
    protected int _style;
    protected int _arcWidth;
    protected int _arcHeight;
    protected String _actionCommand;
    protected Object _commandArgument;
    protected Color _backgroundColor;
    protected Color _alternateColor;
    protected boolean _enabled = true;
    protected boolean _pressed;

    public ButtonSprite(Label label, int style, Color backgroundColor, Color alternateColor, String actionCommand, Object commandArgument) {
        this._label = label;
        this._style = style;
        this._backgroundColor = backgroundColor;
        this._alternateColor = alternateColor;
        this._actionCommand = actionCommand;
        this._commandArgument = commandArgument;
    }

    public ButtonSprite(Label label, int style, int arcWidth, int arcHeight, Color backgroundColor, Color alternateColor, String actionCommand, Object commandArgument) {
        this._label = label;
        this._style = style;
        this._arcWidth = arcWidth;
        this._arcHeight = arcHeight;
        this._backgroundColor = backgroundColor;
        this._alternateColor = alternateColor;
        this._actionCommand = actionCommand;
        this._commandArgument = commandArgument;
    }

    public Label getLabel() {
        return this._label;
    }

    public void updateBounds() {
        this.invalidate();
        Dimension size = this._label.getSize();
        this._bounds.width = size.width + 4 + (this._style == 1 ? this._arcWidth : 0);
        this._bounds.height = size.height + 4;
        this.invalidate();
    }

    public void setStyle(int style) {
        this._style = style;
        this.updateBounds();
    }

    public int getStyle() {
        return this._style;
    }

    public void setArcWidth(int arcWidth) {
        this._arcWidth = arcWidth;
        this.updateBounds();
    }

    public int getArcWidth() {
        return this._arcWidth;
    }

    public void setArcHeight(int arcHeight) {
        this._arcHeight = arcHeight;
        this.updateBounds();
    }

    public int getArcHeight() {
        return this._arcHeight;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this._backgroundColor = backgroundColor;
    }

    public Color getBackgroundColor() {
        return this._backgroundColor;
    }

    public void setActionCommand(String actionCommand) {
        this._actionCommand = actionCommand;
    }

    @Override
    public String getActionCommand() {
        return this._actionCommand;
    }

    public void setCommandArgument(Object commandArgument) {
        this._commandArgument = commandArgument;
    }

    @Override
    public Object getCommandArgument() {
        return this._commandArgument;
    }

    public void setEnabled(boolean enabled) {
        if (this._enabled != enabled) {
            this._enabled = enabled;
            this.invalidate();
        }
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public void setArmed(boolean pressed) {
        if (this._pressed != pressed) {
            this._pressed = pressed;
            this.invalidate();
        }
    }

    public boolean isArmed() {
        return this._pressed;
    }

    @Override
    protected void init() {
        Graphics2D gfx;
        super.init();
        if (!this._label.isLaidOut() && (gfx = this._mgr.createGraphics()) != null) {
            try {
                this._label.layout(gfx);
            }
            finally {
                gfx.dispose();
            }
        }
        this.updateBounds();
    }

    @Override
    public void paint(Graphics2D gfx) {
        Color baseTextColor = this._label.getTextColor();
        Color baseAlternateColor = this._label.getAlternateColor();
        if (!this._enabled) {
            this._label.setTextColor(baseTextColor.darker());
            this._label.setAlternateColor(baseAlternateColor.darker());
        }
        switch (this._style) {
            case 0: {
                gfx.setColor(this._enabled ? this._backgroundColor : this._backgroundColor.darker());
                gfx.fill3DRect(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height, !this._pressed);
                this._label.render(gfx, (float)(this._bounds.x + (this._pressed ? 2 : 1)), (float)(this._bounds.y + (this._pressed ? 2 : 1)));
                break;
            }
            case 1: {
                Object aaState = SwingUtil.activateAntiAliasing((Graphics2D)gfx);
                gfx.setColor(this._alternateColor);
                gfx.fillRoundRect(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height, this._arcWidth, this._arcHeight);
                gfx.setColor(this._enabled ? this._backgroundColor : this._backgroundColor.darker());
                int innerBoundsX = this._bounds.x + 1;
                int innerBoundsY = this._bounds.y + 1;
                int innerBoundsWidth = this._bounds.width - 2;
                int innerBoundsHeight = this._bounds.height - 2;
                int innerBoundsArcWidth = this._arcWidth - 2;
                int innerBoundsArcHeight = this._arcHeight - 2;
                gfx.fillRoundRect(innerBoundsX, innerBoundsY, innerBoundsWidth, innerBoundsHeight, innerBoundsArcWidth, innerBoundsArcHeight);
                Color brighter = this._enabled ? this._backgroundColor.brighter() : this._backgroundColor;
                Color darker = this._enabled ? this._backgroundColor.darker() : this._backgroundColor.darker().darker();
                gfx.setColor(darker);
                gfx.drawArc(innerBoundsX, innerBoundsY, innerBoundsArcWidth, innerBoundsArcHeight, 90, 90);
                gfx.drawArc(innerBoundsX + innerBoundsWidth - innerBoundsArcWidth - 1, innerBoundsY + innerBoundsHeight - innerBoundsArcHeight - 1, innerBoundsArcWidth, innerBoundsArcHeight, 270, 90);
                gfx.setColor(this._pressed ? darker : brighter);
                gfx.drawLine(innerBoundsX + innerBoundsArcWidth / 2, innerBoundsY, innerBoundsX + innerBoundsWidth - innerBoundsArcWidth / 2, innerBoundsY);
                gfx.drawArc(innerBoundsX + innerBoundsWidth - innerBoundsArcWidth - 1, innerBoundsY, innerBoundsArcWidth, innerBoundsArcHeight, 0, 90);
                gfx.drawLine(innerBoundsX + innerBoundsWidth - 1, innerBoundsY + innerBoundsArcHeight / 2, innerBoundsX + innerBoundsWidth - 1, innerBoundsY + innerBoundsHeight - innerBoundsArcHeight / 2);
                gfx.setColor(this._pressed ? brighter : darker);
                gfx.drawLine(innerBoundsX, innerBoundsY + innerBoundsArcHeight / 2, innerBoundsX, innerBoundsY + innerBoundsHeight - innerBoundsArcHeight / 2);
                gfx.drawArc(innerBoundsX, innerBoundsY + innerBoundsHeight - innerBoundsArcHeight - 1, innerBoundsArcWidth, innerBoundsArcHeight, 180, 90);
                gfx.drawLine(innerBoundsX + innerBoundsArcWidth / 2, innerBoundsY + innerBoundsHeight - 1, innerBoundsX + innerBoundsWidth - innerBoundsArcWidth / 2, innerBoundsY + innerBoundsHeight - 1);
                SwingUtil.restoreAntiAliasing((Graphics2D)gfx, (Object)aaState);
                this._label.render(gfx, (float)(this._bounds.x + 2 + this._arcWidth / 2 - (this._pressed ? 2 : 1)), (float)(this._bounds.y + 2 + (this._pressed ? 1 : 0)));
            }
        }
        if (!this._enabled) {
            this._label.setTextColor(baseTextColor);
            this._label.setAlternateColor(baseAlternateColor);
        }
    }
}

