/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.image;

import com.threerings.media.image.Mirage;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class CompositeMirage
implements Mirage {
    protected Mirage[] _mirages;

    public CompositeMirage(Mirage ... mirages) {
        this._mirages = mirages;
    }

    @Override
    public long getEstimatedMemoryUsage() {
        long mem = 0L;
        Mirage[] mirageArray = this._mirages;
        int n = this._mirages.length;
        int n2 = 0;
        while (n2 < n) {
            Mirage m = mirageArray[n2];
            mem += m.getEstimatedMemoryUsage();
            ++n2;
        }
        return mem;
    }

    @Override
    public int getHeight() {
        int height = 0;
        Mirage[] mirageArray = this._mirages;
        int n = this._mirages.length;
        int n2 = 0;
        while (n2 < n) {
            Mirage m = mirageArray[n2];
            height = Math.max(height, m.getHeight());
            ++n2;
        }
        return height;
    }

    @Override
    public int getWidth() {
        int width = 0;
        Mirage[] mirageArray = this._mirages;
        int n = this._mirages.length;
        int n2 = 0;
        while (n2 < n) {
            Mirage m = mirageArray[n2];
            width = Math.max(width, m.getWidth());
            ++n2;
        }
        return width;
    }

    @Override
    public BufferedImage getSnapshot() {
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D gfx = img.createGraphics();
        try {
            Mirage[] mirageArray = this._mirages;
            int n = this._mirages.length;
            int n2 = 0;
            while (n2 < n) {
                Mirage m = mirageArray[n2];
                m.paint(gfx, 0, 0);
                ++n2;
            }
        }
        finally {
            gfx.dispose();
        }
        return img;
    }

    @Override
    public boolean hitTest(int x, int y) {
        Mirage[] mirageArray = this._mirages;
        int n = this._mirages.length;
        int n2 = 0;
        while (n2 < n) {
            Mirage m = mirageArray[n2];
            if (m.hitTest(x, y)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void paint(Graphics2D gfx, int x, int y) {
        Mirage[] mirageArray = this._mirages;
        int n = this._mirages.length;
        int n2 = 0;
        while (n2 < n) {
            Mirage m = mirageArray[n2];
            m.paint(gfx, x, y);
            ++n2;
        }
    }
}

