/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.image;

import com.samskivert.util.StringUtil;
import java.awt.Color;

public class Colorization {
    public int colorizationId;
    public Color rootColor;
    public float[] range;
    public float[] offsets;
    protected int[] _fhsv;
    protected float[] _hsv;

    public Colorization(int colorizationId, Color rootColor, float[] range, float[] offsets) {
        this.colorizationId = colorizationId;
        this.rootColor = rootColor;
        this.range = range;
        this.offsets = offsets;
        this._hsv = Color.RGBtoHSB(rootColor.getRed(), rootColor.getGreen(), rootColor.getBlue(), null);
        this._fhsv = Colorization.toFixedHSV(this._hsv, null);
    }

    public Color getColorizedRoot() {
        return new Color(this.recolorColor(this._hsv));
    }

    public int recolorColor(float[] hsv) {
        float hue = hsv[0] + this.offsets[0];
        if ((double)hue > 1.0) {
            hue = (float)((double)hue - 1.0);
        }
        float sat = Math.min(Math.max(hsv[1] + this.offsets[1], 0.0f), 1.0f);
        float val = Math.min(Math.max(hsv[2] + this.offsets[2], 0.0f), 1.0f);
        return Color.HSBtoRGB(hue, sat, val);
    }

    public boolean matches(float[] hsv, int[] fhsv) {
        if ((float)Colorization.distance(fhsv[0], this._fhsv[0], Short.MAX_VALUE) > this.range[0] * 32767.0f) {
            return false;
        }
        return !(Math.abs(this._hsv[1] - hsv[1]) > this.range[1]) && !(Math.abs(this._hsv[2] - hsv[2]) > this.range[2]);
    }

    public int hashCode() {
        return this.colorizationId ^ this.rootColor.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Colorization) {
            return ((Colorization)other).colorizationId == this.colorizationId;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.colorizationId);
    }

    public String toVerboseString() {
        return StringUtil.fieldsToString((Object)this);
    }

    public static int[] toFixedHSV(float[] hsv, int[] fhsv) {
        if (fhsv == null) {
            fhsv = new int[hsv.length];
        }
        int ii = 0;
        while (ii < hsv.length) {
            fhsv[ii] = (int)(hsv[ii] * 32767.0f);
            ++ii;
        }
        return fhsv;
    }

    public static int distance(int a, int b, int N) {
        return a > b ? Math.min(a - b, b + N - a) : Math.min(b - a, a + N - b);
    }
}

