/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.animation;

import com.threerings.media.animation.Animation;
import com.threerings.media.sprite.PathObserver;
import com.threerings.media.sprite.Sprite;
import com.threerings.media.sprite.SpriteManager;
import com.threerings.media.util.Path;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class SpriteAnimation
extends Animation
implements PathObserver {
    protected Sprite _sprite;
    protected SpriteManager _spritemgr;
    protected Path _path;

    public SpriteAnimation(SpriteManager spritemgr, Sprite sprite, Path path) {
        super(new Rectangle());
        this._spritemgr = spritemgr;
        this._sprite = sprite;
        this._path = path;
        this._sprite.addSpriteObserver(this);
    }

    @Override
    public void tick(long timestamp) {
        if (this._path != null) {
            this._spritemgr.addSprite(this._sprite);
            this._sprite.move(this._path);
            this._path = null;
        }
    }

    @Override
    public void paint(Graphics2D gfx) {
    }

    @Override
    public void pathCancelled(Sprite sprite, Path path) {
        this._finished = true;
    }

    @Override
    public void pathCompleted(Sprite sprite, Path path, long when) {
        this._finished = true;
    }

    @Override
    protected void didFinish(long tickStamp) {
        super.didFinish(tickStamp);
        this._spritemgr.removeSprite(this._sprite);
        this._sprite = null;
    }
}

