/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.animation;

import com.samskivert.util.ObserverList;
import com.threerings.media.AbstractMedia;
import com.threerings.media.animation.AnimationObserver;
import java.awt.Rectangle;

public abstract class Animation
extends AbstractMedia {
    protected boolean _finished = false;

    public Animation(Rectangle bounds) {
        super(bounds);
    }

    public boolean isFinished() {
        return this._finished;
    }

    public void reset() {
        this._finished = false;
    }

    @Override
    public void setLocation(int x, int y) {
        if (this._bounds.x == x && this._bounds.y == y) {
            return;
        }
        Rectangle obounds = new Rectangle(this._bounds);
        super.setLocation(x, y);
        this.invalidateAfterChange(obounds);
    }

    @Override
    protected void willStart(long tickStamp) {
        super.willStart(tickStamp);
        this.queueNotification(new AnimStartedOp(this, tickStamp));
    }

    protected void willFinish(long tickStamp) {
        this.queueNotification(new AnimCompletedOp(this, tickStamp));
    }

    protected void didFinish(long tickStamp) {
    }

    public void addAnimationObserver(AnimationObserver obs) {
        this.addObserver(obs);
    }

    public void removeAnimationObserver(AnimationObserver obs) {
        this.removeObserver(obs);
    }

    protected static class AnimCompletedOp
    implements ObserverList.ObserverOp<Object> {
        protected Animation _anim;
        protected long _when;

        public AnimCompletedOp(Animation anim, long when) {
            this._anim = anim;
            this._when = when;
        }

        public boolean apply(Object observer) {
            ((AnimationObserver)observer).animationCompleted(this._anim, this._when);
            return true;
        }
    }

    protected static class AnimStartedOp
    implements ObserverList.ObserverOp<Object> {
        protected Animation _anim;
        protected long _when;

        public AnimStartedOp(Animation anim, long when) {
            this._anim = anim;
            this._when = when;
        }

        public boolean apply(Object observer) {
            ((AnimationObserver)observer).animationStarted(this._anim, this._when);
            return true;
        }
    }
}

