/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media;

import com.samskivert.swing.RuntimeAdjust;
import com.samskivert.util.ListUtil;
import com.samskivert.util.RunAnywhere;
import com.samskivert.util.StringUtil;
import com.threerings.media.ActiveRepaintManager;
import com.threerings.media.BackFrameManager;
import com.threerings.media.FlipFrameManager;
import com.threerings.media.FrameParticipant;
import com.threerings.media.Log;
import com.threerings.media.ManagedJFrame;
import com.threerings.media.MediaOverlay;
import com.threerings.media.MediaPrefs;
import com.threerings.media.timer.CalibratingTimer;
import com.threerings.media.timer.MediaTimer;
import com.threerings.media.timer.MillisTimer;
import com.threerings.media.util.TrailingAverage;
import com.threerings.util.unsafe.Unsafe;
import java.applet.Applet;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;

public abstract class FrameManager {
    protected Window _window;
    protected ManagedRoot _root;
    protected MediaTimer _timer;
    protected ActiveRepaintManager _repainter;
    protected MediaOverlay _overlay;
    protected long _millisPerFrame = 14L;
    protected long _lastTickStamp;
    protected Ticker _ticker;
    protected float[] _fps = new float[2];
    protected TrailingAverage[] _metrics;
    protected Rectangle _tbounds = new Rectangle();
    protected boolean[] _clipped = new boolean[1];
    protected Object[] _participants = new Object[4];
    protected static final long BIG_GAP = 500L;
    protected static final long HANG_GAP = 100L;
    protected static final boolean HANG_DEBUG = false;
    protected static RuntimeAdjust.BooleanAdjust _useFlip = new RuntimeAdjust.BooleanAdjust("When active a flip-buffer will be used to manage our rendering, otherwise a volatile back buffer is used [requires restart]", "narya.media.frame", MediaPrefs.config, RunAnywhere.isMacOS());
    protected static RuntimeAdjust.IntAdjust _sleepGranularity = new RuntimeAdjust.IntAdjust("The number of milliseconds slept before checking to see if it's time to queue up a new frame tick.", "narya.media.sleep_gran", MediaPrefs.config, RunAnywhere.isWindows() ? 10 : 7);
    protected static RuntimeAdjust.BooleanAdjust _perfDebug = new RuntimeAdjust.BooleanAdjust("Toggles frames per second and dirty regions per tick rendering.", "narya.media.fps_display", MediaPrefs.config, false);
    protected static final String[] PERF_TIMERS = new String[]{"com.threerings.media.timer.NanoTimer"};

    public static FrameManager newInstance(ManagedRoot root) {
        return FrameManager.newInstance(root, FrameManager.createTimer());
    }

    public static MediaTimer createTimer() {
        MediaTimer timer = null;
        String[] stringArray = PERF_TIMERS;
        int n = PERF_TIMERS.length;
        int n2 = 0;
        while (n2 < n) {
            String timerClass = stringArray[n2];
            try {
                timer = (MediaTimer)Class.forName(timerClass).newInstance();
                break;
            }
            catch (Throwable throwable) {
                ++n2;
            }
        }
        if (timer == null) {
            Log.log.info((Object)"Can't use high performance timer, reverting to System.currentTimeMillis() based timer.", new Object[0]);
            timer = new MillisTimer();
        }
        return timer;
    }

    public static FrameManager newInstance(ManagedRoot root, MediaTimer timer) {
        BackFrameManager fmgr = root instanceof ManagedJFrame && _useFlip.getValue() ? new FlipFrameManager() : new BackFrameManager();
        fmgr.init(root, timer);
        return fmgr;
    }

    public void setTargetFrameRate(int fps) {
        this._millisPerFrame = 1000 / fps;
    }

    public void registerFrameParticipant(FrameParticipant participant) {
        Object[] nparts = ListUtil.testAndAddRef((Object[])this._participants, (Object)participant);
        if (nparts == null) {
            Log.log.warning((Object)("Refusing to add duplicate frame participant! " + participant), new Object[0]);
        } else {
            this._participants = nparts;
        }
    }

    public boolean isRegisteredFrameParticipant(FrameParticipant participant) {
        return ListUtil.containsRef((Object[])this._participants, (Object)participant);
    }

    public void removeFrameParticipant(FrameParticipant participant) {
        ListUtil.clearRef((Object[])this._participants, (Object)participant);
    }

    public long getTimeStamp() {
        return this._timer.getElapsedMillis();
    }

    public float getMaxTimerDriftRatio() {
        if (this._timer instanceof CalibratingTimer) {
            return ((CalibratingTimer)this._timer).getMaxDriftRatio();
        }
        return 1.0f;
    }

    public void clearMaxTimerDriftRatio() {
        if (this._timer instanceof CalibratingTimer) {
            ((CalibratingTimer)this._timer).clearMaxDriftRatio();
        }
    }

    public MediaOverlay getMediaOverlay() {
        if (this._overlay == null) {
            this._overlay = new MediaOverlay(this);
        }
        return this._overlay;
    }

    public ManagedRoot getManagedRoot() {
        return this._root;
    }

    public void clearMediaOverlay() {
        if (this._overlay != null) {
            this._overlay = null;
        }
    }

    public void start() {
        if (this._ticker == null) {
            this._ticker = new Ticker();
            this._ticker.start();
            this._lastTickStamp = 0L;
        }
    }

    public synchronized void stop() {
        if (this._ticker != null) {
            this._ticker.cancel();
            this._ticker = null;
        }
    }

    public synchronized boolean isRunning() {
        return this._ticker != null;
    }

    public int getPerfTicks() {
        return Math.round(this._fps[1]);
    }

    public int getPerfTries() {
        return Math.round(this._fps[0]);
    }

    public TrailingAverage[] getPerfMetrics() {
        if (this._metrics == null) {
            this._metrics = new TrailingAverage[]{new TrailingAverage(150), new TrailingAverage(150), new TrailingAverage(150)};
        }
        return this._metrics;
    }

    public static Component getRoot(Component comp, Rectangle rect) {
        Component c = comp;
        while (c != null) {
            if (!c.isVisible() || !c.isDisplayable()) {
                return null;
            }
            if (c instanceof Window || c instanceof Applet) {
                return c;
            }
            rect.x += c.getX();
            rect.y += c.getY();
            c = c.getParent();
        }
        return null;
    }

    protected void init(ManagedRoot root, MediaTimer timer) {
        this._window = root.getWindow();
        this._root = root;
        this._root.init(this);
        this._timer = timer;
        this._repainter = new ActiveRepaintManager(this._root instanceof Component ? (Component)((Object)this._root) : this._window);
        RepaintManager.setCurrentManager(this._repainter);
        this._repainter.setDoubleBufferingEnabled(false);
    }

    protected void tick(long tickStamp) {
        long start = 0L;
        long paint = 0L;
        if (_perfDebug.getValue()) {
            start = paint = this._timer.getElapsedMicros();
        }
        if (this._window.isShowing() && this._window.getWidth() > 0 && this._window.getHeight() > 0) {
            this.tickParticipants(tickStamp);
            paint = this._timer.getElapsedMicros();
            this.paint(tickStamp);
        }
        if (_perfDebug.getValue()) {
            long end = this._timer.getElapsedMicros();
            this.getPerfMetrics()[1].record((int)(paint - start) / 100);
            this.getPerfMetrics()[2].record((int)(end - paint) / 100);
        }
    }

    protected void tickParticipants(long tickStamp) {
        long gap = tickStamp - this._lastTickStamp;
        if (this._lastTickStamp != 0L && gap > 500L) {
            Log.log.debug((Object)("Long tick delay [delay=" + gap + "ms]."), new Object[0]);
        }
        this._lastTickStamp = tickStamp;
        try {
            this._repainter.validateComponents();
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Failure validating components.", new Object[]{t});
        }
        Object[] objectArray = this._participants;
        int n = this._participants.length;
        int n2 = 0;
        while (n2 < n) {
            Object participant = objectArray[n2];
            FrameParticipant part = (FrameParticipant)participant;
            if (part != null) {
                try {
                    long start = 0L;
                    part.tick(tickStamp);
                }
                catch (Throwable t) {
                    Log.log.warning((Object)"Frame participant choked during tick", new Object[]{"part", StringUtil.safeToString((Object)part), t});
                }
            }
            ++n2;
        }
        if (this._overlay != null) {
            this._overlay.tick(tickStamp);
        }
    }

    protected abstract void paint(long var1);

    protected abstract Graphics2D createGraphics();

    protected boolean paint(Graphics2D gfx) {
        int painted = 0;
        Object[] objectArray = this._participants;
        int n = this._participants.length;
        int n2 = 0;
        while (n2 < n) {
            Component pcomp;
            Object participant = objectArray[n2];
            FrameParticipant part = (FrameParticipant)participant;
            if (part != null && (pcomp = part.getComponent()) != null && part.needsPaint()) {
                long start = 0L;
                pcomp.getBounds(this._tbounds);
                this._tbounds.setLocation(0, 0);
                if (FrameManager.getRoot(pcomp, this._tbounds) != null) {
                    try {
                        gfx.translate(this._tbounds.x, this._tbounds.y);
                        pcomp.paint(gfx);
                        gfx.translate(-this._tbounds.x, -this._tbounds.y);
                        ++painted;
                    }
                    catch (Throwable t) {
                        String ptos = StringUtil.safeToString((Object)part);
                        Log.log.warning((Object)("Frame participant choked during paint [part=" + ptos + "]."), new Object[]{t});
                    }
                    this._clipped[0] = false;
                    this.renderLayers(gfx, pcomp, this._tbounds, this._clipped, this._tbounds);
                }
            }
            ++n2;
        }
        if (this._overlay != null) {
            this._overlay.propagateDirtyRegions(this._repainter, this._root.getRootPane());
        }
        boolean pcomp = this._repainter.paintComponents(gfx, this);
        if (this._overlay != null) {
            pcomp |= this._overlay.paint(gfx);
        }
        return painted > 0 || pcomp;
    }

    protected abstract void restoreFromBack(Rectangle var1);

    protected void renderLayers(Graphics2D g, Component pcomp, Rectangle bounds, boolean[] clipped, Rectangle dirty) {
        JLayeredPane lpane = JLayeredPane.getLayeredPaneAbove(pcomp);
        if (lpane != null) {
            this.renderLayer(g, bounds, lpane, clipped, JLayeredPane.PALETTE_LAYER);
            this.renderLayer(g, bounds, lpane, clipped, JLayeredPane.MODAL_LAYER);
            this.renderLayer(g, bounds, lpane, clipped, JLayeredPane.POPUP_LAYER);
            this.renderLayer(g, bounds, lpane, clipped, JLayeredPane.DRAG_LAYER);
        }
        if (this._overlay != null) {
            this._overlay.addDirtyRegion(dirty);
        }
    }

    protected void renderLayer(Graphics2D g, Rectangle bounds, JLayeredPane pane, boolean[] clipped, Integer layer) {
        int ccount = pane.getComponentCountInLayer(layer);
        if (ccount == 0) {
            return;
        }
        Component[] comps = pane.getComponentsInLayer(layer);
        int ii = 0;
        while (ii < ccount) {
            Component comp = comps[ii];
            if (comp.isVisible() && !(comp instanceof SafeLayerComponent)) {
                Rectangle compBounds = new Rectangle(0, 0, comp.getWidth(), comp.getHeight());
                FrameManager.getRoot(comp, compBounds);
                if (compBounds.intersects(bounds)) {
                    if (!clipped[0]) {
                        g.setClip(bounds);
                        clipped[0] = true;
                    }
                    g.translate(compBounds.x, compBounds.y);
                    try {
                        comp.paint(g);
                    }
                    catch (Exception e) {
                        Log.log.warning((Object)"Component choked while rendering.", new Object[]{e});
                    }
                    g.translate(-compBounds.x, -compBounds.y);
                }
            }
            ++ii;
        }
    }

    public static interface ManagedRoot {
        public void init(FrameManager var1);

        public Window getWindow();

        public JRootPane getRootPane();
    }

    public static interface SafeLayerComponent {
    }

    protected class Ticker
    extends Thread {
        protected Runnable _awtTicker;
        protected transient boolean _running;
        protected boolean _ticking;
        protected long _lastAttempt;
        protected int _tries;
        protected int _ticks;
        protected int _time;
        protected long _lastTick;

        public Ticker() {
            super("FrameManagerTicker");
            this._awtTicker = new Runnable(){

                @Override
                public void run() {
                    long elapsed = ((Ticker)Ticker.this).FrameManager.this._timer.getElapsedMillis();
                    try {
                        FrameManager.this.tick(elapsed);
                    }
                    finally {
                        Ticker.this.clearTicking(elapsed);
                    }
                }
            };
            this._running = true;
        }

        @Override
        public void run() {
            Log.log.info((Object)"Frame manager ticker running", new Object[]{"sleepGran", _sleepGranularity.getValue()});
            while (this._running) {
                long start = 0L;
                if (_perfDebug.getValue()) {
                    start = FrameManager.this._timer.getElapsedMicros();
                }
                Unsafe.sleep(_sleepGranularity.getValue());
                long woke = FrameManager.this._timer.getElapsedMicros();
                if (start > 0L) {
                    FrameManager.this.getPerfMetrics()[0].record((int)(woke - start) / 100);
                    int elapsed = (int)(woke - start);
                    if (elapsed > _sleepGranularity.getValue() * 1500) {
                        Log.log.warning((Object)"Long tick", new Object[]{"elapsed", String.valueOf(elapsed) + "us"});
                    }
                }
                if (woke < this._lastAttempt) {
                    Log.log.warning((Object)"Zoiks! We've leapt into the past, coping as best we can", new Object[]{"dt", woke - this._lastAttempt});
                    this._lastAttempt = woke;
                }
                if (woke - this._lastAttempt < FrameManager.this._millisPerFrame * 1000L) continue;
                this._lastAttempt = woke;
                if (!this.testAndSet()) continue;
                EventQueue.invokeLater(this._awtTicker);
            }
        }

        public void cancel() {
            this._running = false;
        }

        protected final synchronized boolean testAndSet() {
            ++this._tries;
            if (!this._ticking) {
                this._ticking = true;
                return true;
            }
            return false;
        }

        protected final synchronized void clearTicking(long elapsed) {
            if (++this._ticks == 100) {
                long time = elapsed - this._lastTick;
                FrameManager.this._fps[0] = (float)this._tries * 1000.0f / (float)time;
                FrameManager.this._fps[1] = (float)this._ticks * 1000.0f / (float)time;
                this._lastTick = elapsed;
                this._tries = 0;
                this._ticks = 0;
            }
            this._ticking = false;
        }
    }
}

