package com.threerings.media.util;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import com.samskivert.util.HashIntMap;
import com.threerings.media.util.BStarPathUtil.TraversalPred;

public class BStarPathUtil {

	/**
     * Provides traversibility information when computing paths.
     */
    public static interface TraversalPred
    {
        /**
         * Requests to know if the specified traverser (which was provided in the call to
         * {@link #getPath(TraversalPred,Object,int,int,int,int,int,boolean)}) can traverse the
         * specified tile coordinate.
         */
        public boolean canTraverse (Object traverser, int x, int y);
    }
    
    
    /**
     * Considers all the possible steps the piece in question can take.
     */
    public static class Stepper
    {
        public Stepper () {
            this(true);
        }

        public Stepper (boolean considerDiagonals) {
            _considerDiagonals = considerDiagonals;
        }

        public void init (Info info, Node n) {
            _info = info;
            _node = n;
        }

        /**
         * Should call {@link #considerStep} in turn on all possible steps from the specified
         * coordinates. No checking must be done as to whether the step is legal, that will be
         * handled later. Just enumerate all possible steps.
         */
        public void considerSteps (int x, int y) {
        	
        	if(_node.parent != null) {
        		/**
        		 * 原路径前进方向
        		 */
        		boolean head = considerStep(2*x-_node.parent.x,2*y-_node.parent.y);
        		
        		if(!head) {
        			
        		}
        		
        	}else {
        		if(Math.abs(x-_info.destx) > Math.abs((y-_info.desty))){
        			
        		}
        	}
        	considerStep(x, y - 1);
            considerStep(x, y + 1);
            considerStep(x - 1, y);
            considerStep(x + 1, y);
        }
        
        protected boolean considerStep (int x, int y) {
        	if(_node.parent != null) {
        		if(_node.parent.x == x && _node.parent.y == y) {
        			return false;
        		}
        	}
        	boolean result= BStarPathUtil.considerStep(_info, _node, x, y);
        	return result;
        }

        protected boolean _considerDiagonals;
        protected Info _info;
        protected Node _node;
    }
    
    public class Tetrad {
    	int x,y;
    	boolean b;
    }
    
    /**
     * Consider the step <code>(n.x, n.y)</code> to <code>(x, y)</code> for possible inclusion
     * in the path.
     *
     * @param info the info object.
     * @param n the originating node for the step.
     * @param x the x-coordinate for the destination step.
     * @param y the y-coordinate for the destination step.
     */
    protected static boolean considerStep (Info info, Node n, int x, int y)
    {
        // skip node if it's outside the map bounds or otherwise impassable
        if (!info.isStepValid(n.x, n.y, x, y)) {
            return false;
        }

        // retrieve the node corresponding to this location
        Node np = info.getNode(x, y);

        // skip if it's already in the open or closed list or if its
        // actual cost is less than the just-calculated cost
        if ((np.closed || info.open.contains(np))) {
            return false;
        }

        // remove the node from the open list since we're about to
        // modify its score which determines its placement in the list
        info.open.remove(np);

        // update the node's information
        np.parent = n;
        np.h = getDistanceEstimate(np.x, np.y, info.destx, info.desty);
        np.f = np.g + np.h;

        // remove it from the closed list if it's present
        np.closed = false;

        // add it to the open list for further consideration
        info.open.add(np);
        
        return true;
    }
    
    /**
     * Return a heuristic estimate of the cost to get from <code>(ax, ay)</code> to
     * <code>(bx, by)</code>.
     */
    protected static int getDistanceEstimate (int ax, int ay, int bx, int by)
    {
        // we're doing all of our cost calculations based on geometric distance times ten
        int xsq = bx - ax;
        int ysq = by - ay;
        return (int) (Math.sqrt(xsq * xsq + ysq * ysq));
    }
    
    
    public static enum Status{
    	NONE,CRAWLING,DIVARICATION,CLOSE;
    }
    
    /**
     * A holding class to contain the wealth of information referenced
     * while performing an A* search for a path through a tile array.
     */
    protected static class Info
    {
        /** Knows whether or not tiles are traversable. */
        public TraversalPred tpred;

        /** The tile array dimensions. */
        public int tilewid, tilehei;

        /** The traverser moving along the path. */
        public Object trav;

        /** The set of open nodes being searched. */
        public Set<Node> open;

        /** The destination coordinates in the tile array. */
        public int destx, desty;

        /** The nodes being considered in the path. */
        protected HashIntMap<Node> _nodes = new HashIntMap<Node>();
        
        
        
        public Info (TraversalPred tpred, Object trav, int longest, int destx, int desty) {
            // save off references
            this.tpred = tpred;
            this.trav = trav;
            this.destx = destx;
            this.desty = desty;

            // construct the open and closed lists
            open = new TreeSet<Node>();
        }

        /**
         * Returns whether moving from the given source to destination coordinates is a valid
         * move.
         */
        protected boolean isStepValid (int sx, int sy, int dx, int dy) {
           if (!isTraversable(dx, dy)) {
                return false;
            }

            // if the step is diagonal, make sure the corners don't impede our progress
            if ((Math.abs(dx - sx) == 1) && (Math.abs(dy - sy) == 1)) {
                return isTraversable(dx, sy) && isTraversable(sx, dy);
            }

            // non-diagonals are always traversable
            return true;
        }

        /**
         * Returns whether the given coordinate is valid and traversable.
         */
        protected boolean isTraversable (int x, int y) {
            return tpred.canTraverse(trav, x, y);
        }

        /**
         * Get or create the node for the specified point.
         */
        public Node getNode (int x, int y) {
            // note: this _could_ break for unusual values of x and y.
            // perhaps use a IntTuple as a key? Bleah.
            int key = (x << 16) | (y & 0xffff);
            Node node = _nodes.get(key);
            if (node == null) {
                node = new Node(x, y);
                _nodes.put(key, node);
            }
            return node;
        }
    }
    
    public static class Branch{
    	
    	private Info info;
    	public Branch left,right;
    	public List<Node> nodes = new ArrayList<Node>();
    	public Node current;
    	public Branch parent;
    	public boolean closed;
    	
    	public Branch(Info info,Branch parent,Node current) {
    		this.info = info;
    		this.parent = parent;
    		this.current = current;
    		nodes.add(current);
    	}
    	
    	
    }

    /**
     * A class that represents a single traversable node in the tile array
     * along with its current A*-specific search information.
     */
    public static class Node implements Comparable<Node>
    {
        /** The node coordinates. */
        public int x, y;

        /** The actual cheapest cost of arriving here from the start. */
        public int g;

        /** The heuristic estimate of the cost to the goal from here. */
        public int h;

        /** The score assigned to this node. */
        public int f;

        /** The node from which we reached this node. */
        public Node parent;

        /** The node's monotonically-increasing unique identifier. */
        public int id;

        public Node left,right;
        
        /** The node's status */
        public Status status;
        
        /** Whether or not this node is on the closed list. */
        public boolean closed;
        
        public Node (int x, int y) {
            this.x = x;
            this.y = y;
            id = _nextid++;
        }

        public int compareTo (Node o) {
            int bf = o.f;

            // since the set contract is fulfilled using the equality results returned here, and
            // we'd like to allow multiple nodes with equivalent scores in our set, we explicitly
            // define object equivalence as the result of object.equals(), else we use the unique
            // node id since it will return a consistent ordering for the objects.
            if (f == bf) {
                return (this == o) ? 0 : (id - o.id);
            }

            return f - bf;
        }

        /** The next unique node id. */
        protected static int _nextid = 0;
    }
    
    /**
     * Return a list of <code>Point</code> objects representing a path from coordinates
     * <code>(ax, by)</code> to <code>(bx, by)</code>, inclusive, determined by performing an
     * A* search in the given scene's base tile layer. Assumes the starting and destination nodes
     * are traversable by the specified traverser.
     *
     * @param tpred lets us know what tiles are traversible.
     * @param stepper enumerates the possible steps.
     * @param trav the traverser to follow the path.
     * @param longest the longest allowable path in tile traversals. This arg must be less than
     *        Integer.MAX_VALUE / ADJACENT_COST, even if your stepper uses a
     *        different fucking adjacent cost.
     * @param ax the starting x-position in tile coordinates.
     * @param ay the starting y-position in tile coordinates.
     * @param bx the ending x-position in tile coordinates.
     * @param by the ending y-position in tile coordinates.
     * @param partial if true, a partial path will be returned that gets us as close as we can to
     * the goal in the event that a complete path cannot be located.
     *
     * @return the list of points in the path, or null if no path could be found.
     */
    public static List<Point> getPath (
        TraversalPred tpred, Stepper stepper, Object trav, int longest,
        int ax, int ay, int bx, int by, boolean partial)
    {
        Info info = new Info(tpred, trav, longest, bx, by);

        // set up the starting node
        Node s = info.getNode(ax, ay);
        s.g = 0;
        s.h = getDistanceEstimate(ax, ay, bx, by);
        s.f = s.g + s.h;

        // push starting node on the open list
        info.open.add(s);

        // track the best path
        float bestdist = Float.MAX_VALUE;
        Node bestpath = null;

        // while there are more nodes on the open list
        while (info.open.size() > 0) {

        	Iterator<Node> it = info.open.iterator();
        	while(it.hasNext()) {
        		Node n = it.next();
	            // pop the best node so far from open
	
	            // if node is a goal node
	            if (n.x == bx && n.y == by) {
	                // construct and return the acceptable path
	                return getNodePath(n);
	
	            } else if (partial) {
	                float pathdist = MathUtil.distance(n.x, n.y, bx, by);
	                if (pathdist < bestdist) {
	                    bestdist = pathdist;
	                    bestpath = n;
	                }
	            }
	
	            // consider each successor of the node
	            stepper.init(info, n);
	            stepper.considerSteps(n.x, n.y);
	            if(n.status == Status.CLOSE || n.status == Status.CRAWLING) {
	            	it.remove();
	            	 // push the node on the closed list
		            n.closed = true;
	            }else if(n.status == Status.DIVARICATION){
	            	it.remove();
	            }
	           
	        }
        }

        // return the best path we could find if we were asked to do so
        if (bestpath != null) {
            return getNodePath(bestpath);
        }

        // no path found
        return null;
    }

	private static List<Point> getNodePath(Node n) {
		return null;
	}
}
