/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.google.common.collect.Lists;
import com.threerings.openal.Buffer;
import com.threerings.openal.SoundManager;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;

public class Source {
    protected IntBuffer _idbuf;
    protected SoundManager _soundmgr;
    protected int _id;
    protected float _px;
    protected float _py;
    protected float _pz;
    protected float _vx;
    protected float _vy;
    protected float _vz;
    protected float _gain = 1.0f;
    protected boolean _sourceRelative;
    protected boolean _looping;
    protected float _minGain;
    protected float _maxGain = 1.0f;
    protected float _referenceDistance = 1.0f;
    protected float _rolloffFactor = 1.0f;
    protected float _maxDistance = Float.MAX_VALUE;
    protected float _pitch = 1.0f;
    protected float _dx;
    protected float _dy;
    protected float _dz;
    protected float _coneInnerAngle = 360.0f;
    protected float _coneOuterAngle = 360.0f;
    protected float _coneOuterGain;
    protected ArrayList<Buffer> _queue = Lists.newArrayList();

    public Source(SoundManager soundmgr) {
        this._soundmgr = soundmgr;
        this._idbuf = BufferUtils.createIntBuffer((int)1);
        AL10.alGenSources((IntBuffer)this._idbuf);
        this._id = this._idbuf.get(0);
    }

    public final int getId() {
        return this._id;
    }

    public void setPosition(float x, float y, float z) {
        if (this._px != x || this._py != y || this._pz != z) {
            this._px = x;
            this._py = y;
            this._pz = z;
            AL10.alSource3f((int)this._id, (int)4100, (float)this._px, (float)this._py, (float)this._pz);
        }
    }

    public void setVelocity(float x, float y, float z) {
        if (this._vx != x || this._vy != y || this._vz != z) {
            this._vx = x;
            this._vy = y;
            this._vz = z;
            AL10.alSource3f((int)this._id, (int)4102, (float)this._vx, (float)this._vy, (float)this._vz);
        }
    }

    public void setGain(float gain) {
        if (this._gain != gain) {
            this._gain = gain;
            AL10.alSourcef((int)this._id, (int)4106, (float)this._gain);
        }
    }

    public void setSourceRelative(boolean relative) {
        if (this._sourceRelative != relative) {
            this._sourceRelative = relative;
            AL10.alSourcei((int)this._id, (int)514, (int)(relative ? 1 : 0));
        }
    }

    public void setLooping(boolean looping) {
        if (this._looping != looping) {
            this._looping = looping;
            AL10.alSourcei((int)this._id, (int)4103, (int)(looping ? 1 : 0));
        }
    }

    public void setMinGain(float gain) {
        if (this._minGain != gain) {
            this._minGain = gain;
            AL10.alSourcef((int)this._id, (int)4109, (float)this._minGain);
        }
    }

    public void setMaxGain(float gain) {
        if (this._maxGain != gain) {
            this._maxGain = gain;
            AL10.alSourcef((int)this._id, (int)4110, (float)this._maxGain);
        }
    }

    public void setReferenceDistance(float distance) {
        if (this._referenceDistance != distance) {
            this._referenceDistance = distance;
            AL10.alSourcef((int)this._id, (int)4128, (float)this._referenceDistance);
        }
    }

    public void setRolloffFactor(float rolloff) {
        if (this._rolloffFactor != rolloff) {
            this._rolloffFactor = rolloff;
            AL10.alSourcef((int)this._id, (int)4129, (float)this._rolloffFactor);
        }
    }

    public void setMaxDistance(float distance) {
        if (this._maxDistance != distance) {
            this._maxDistance = distance;
            AL10.alSourcef((int)this._id, (int)4131, (float)this._maxDistance);
        }
    }

    public void setPitch(float pitch) {
        if (this._pitch != pitch) {
            this._pitch = pitch;
            AL10.alSourcef((int)this._id, (int)4099, (float)this._pitch);
        }
    }

    public void setDirection(float x, float y, float z) {
        if (this._dx != x || this._dy != y || this._dz != z) {
            this._dx = x;
            this._dy = y;
            this._dz = z;
            AL10.alSource3f((int)this._id, (int)4101, (float)this._dx, (float)this._dy, (float)this._dz);
        }
    }

    public void setConeInnerAngle(float angle) {
        if (this._coneInnerAngle != angle) {
            this._coneInnerAngle = angle;
            AL10.alSourcef((int)this._id, (int)4097, (float)this._coneInnerAngle);
        }
    }

    public void setConeOuterAngle(float angle) {
        if (this._coneOuterAngle != angle) {
            this._coneOuterAngle = angle;
            AL10.alSourcef((int)this._id, (int)4098, (float)this._coneOuterAngle);
        }
    }

    public void setConeOuterGain(float gain) {
        if (this._coneOuterGain != gain) {
            this._coneOuterGain = gain;
            AL10.alSourcef((int)this._id, (int)4130, (float)this._coneOuterGain);
        }
    }

    public void setBuffer(Buffer buffer) {
        this._queue.clear();
        if (buffer != null) {
            this._queue.add(buffer);
        }
        AL10.alSourcei((int)this._id, (int)4105, (int)(buffer == null ? 0 : buffer.getId()));
    }

    public void queueBuffers(Buffer ... buffers) {
        IntBuffer idbuf = BufferUtils.createIntBuffer((int)buffers.length);
        int ii = 0;
        while (ii < buffers.length) {
            Buffer buffer = buffers[ii];
            this._queue.add(buffer);
            idbuf.put(ii, buffer.getId());
            ++ii;
        }
        AL10.alSourceQueueBuffers((int)this._id, (IntBuffer)idbuf);
    }

    public void unqueueBuffers(Buffer ... buffers) {
        IntBuffer idbuf = BufferUtils.createIntBuffer((int)buffers.length);
        int ii = 0;
        while (ii < buffers.length) {
            Buffer buffer = buffers[ii];
            this._queue.remove(buffer);
            idbuf.put(ii, buffer.getId());
            ++ii;
        }
        AL10.alSourceUnqueueBuffers((int)this._id, (IntBuffer)idbuf);
    }

    public boolean isPlaying() {
        return this.getSourceState() == 4114;
    }

    public boolean isPaused() {
        return this.getSourceState() == 4115;
    }

    public boolean isStopped() {
        return this.getSourceState() == 4116;
    }

    public int getSourceState() {
        return AL10.alGetSourcei((int)this._id, (int)4112);
    }

    public int getBuffersProcessed() {
        return AL10.alGetSourcei((int)this._id, (int)4118);
    }

    public float getSecOffset() {
        return AL10.alGetSourcef((int)this._id, (int)4132);
    }

    public int getSampleOffset() {
        return AL10.alGetSourcei((int)this._id, (int)4133);
    }

    public int getByteOffset() {
        return AL10.alGetSourcei((int)this._id, (int)4134);
    }

    public void play() {
        AL10.alSourcePlay((int)this._id);
    }

    public void pause() {
        AL10.alSourcePause((int)this._id);
    }

    public void stop() {
        AL10.alSourceStop((int)this._id);
    }

    public void rewind() {
        AL10.alSourceRewind((int)this._id);
    }

    public void delete() {
        this._idbuf.rewind();
        AL10.alDeleteSources((IntBuffer)this._idbuf);
        this._id = 0;
        this._queue.clear();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._id > 0) {
            this._soundmgr.sourceFinalized(this._id);
        }
    }
}

