/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.image;

import com.threerings.media.image.Mirage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class SolidMirage
implements Mirage {
    protected final Color _color;
    protected final int _width;
    protected final int _height;

    public SolidMirage(Color color, int width, int height) {
        this._color = color;
        this._width = width;
        this._height = height;
    }

    @Override
    public long getEstimatedMemoryUsage() {
        return 0L;
    }

    @Override
    public int getHeight() {
        return this._height;
    }

    @Override
    public BufferedImage getSnapshot() {
        BufferedImage snap = new BufferedImage(this._width, this._height, 1);
        int rgb = this._color.getRGB();
        int x = 0;
        while (x < this._width) {
            int y = 0;
            while (y < this._height) {
                snap.setRGB(x, y, rgb);
                ++y;
            }
            ++x;
        }
        return snap;
    }

    @Override
    public int getWidth() {
        return this._width;
    }

    @Override
    public boolean hitTest(int x, int y) {
        return x >= 0 && x < this._width && y >= 0 && y < this._height;
    }

    @Override
    public void paint(Graphics2D gfx, int x, int y) {
        Color ocolor = gfx.getColor();
        gfx.setColor(this._color);
        gfx.fillRect(x, y, this._width, this._height);
        gfx.setColor(ocolor);
    }
}

