/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media;

import com.samskivert.util.ObserverList;
import com.samskivert.util.StringUtil;
import com.threerings.media.AbstractMediaManager;
import com.threerings.media.Log;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class AbstractMedia
implements Shape {
    public static final int HUD_LAYER = 65536;
    protected int _renderOrder = 0;
    protected Rectangle _bounds;
    protected AbstractMediaManager _mgr;
    protected ObserverList<Object> _observers = null;
    protected long _firstTick;

    public AbstractMedia(Rectangle bounds) {
        this._bounds = bounds;
    }

    public abstract void tick(long var1);

    public abstract void paint(Graphics2D var1);

    public void fastForward(long timeDelta) {
        this._firstTick += timeDelta;
    }

    public void invalidate() {
        if (this._mgr != null) {
            this._mgr.getRegionManager().invalidateRegion(this._bounds);
        }
    }

    public void setLocation(int x, int y) {
        this._bounds.x = x;
        this._bounds.y = y;
    }

    @Override
    public Rectangle getBounds() {
        return this._bounds;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this._bounds;
    }

    @Override
    public boolean contains(double x, double y) {
        return this._bounds.contains(x, y);
    }

    @Override
    public boolean contains(Point2D p) {
        return this._bounds.contains(p);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this._bounds.intersects(x, y, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this._bounds.intersects(r);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this._bounds.contains(x, y, w, h);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this._bounds.contains(r);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this._bounds.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this._bounds.getPathIterator(at, flatness);
    }

    public int renderCompareTo(AbstractMedia other) {
        int result = this._renderOrder - other._renderOrder;
        return result != 0 ? result : this.naturalCompareTo(other);
    }

    public void setRenderOrder(int renderOrder) {
        if (this._renderOrder != renderOrder) {
            this._renderOrder = renderOrder;
            if (this._mgr != null) {
                this._mgr.renderOrderDidChange(this);
                this.invalidate();
            }
        }
    }

    public int getRenderOrder() {
        return this._renderOrder;
    }

    public void queueNotification(ObserverList.ObserverOp<Object> amop) {
        if (this._observers != null) {
            if (this._mgr != null) {
                this._mgr.queueNotification(this._observers, amop);
            } else {
                Log.log.warning((Object)"Have no manager, dropping notification", new Object[]{"media", this, "op", amop});
            }
        }
    }

    public void viewLocationDidChange(int dx, int dy) {
        if (this._renderOrder >= 65536) {
            this.setLocation(this._bounds.x + dx, this._bounds.y + dy);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(StringUtil.shortClassName((Object)this));
        buf.append("[");
        this.toString(buf);
        return buf.append("]").toString();
    }

    public final void init(AbstractMediaManager manager) {
        this._mgr = manager;
        this.init();
    }

    protected void init() {
    }

    protected void willStart(long tickStamp) {
        this._firstTick = tickStamp;
    }

    protected void invalidateAfterChange(Rectangle obounds) {
        if (this._mgr == null) {
            return;
        }
        if (this._bounds.intersects(obounds)) {
            obounds.add(this._bounds);
        } else {
            this._mgr.getRegionManager().invalidateRegion(this._bounds);
        }
        this._mgr.getRegionManager().addDirtyRegion(obounds);
    }

    protected void shutdown() {
        this.invalidate();
        this._mgr = null;
    }

    protected void addObserver(Object obs) {
        if (this._observers == null) {
            this._observers = ObserverList.newFastUnsafe();
        }
        this._observers.add(obs);
    }

    protected void removeObserver(Object obs) {
        if (this._observers != null) {
            this._observers.remove(obs);
        }
    }

    protected int naturalCompareTo(AbstractMedia other) {
        return this.hashCode() - other.hashCode();
    }

    protected void toString(StringBuilder buf) {
        buf.append("bounds=").append(StringUtil.toString((Object)this._bounds));
        buf.append(", renderOrder=").append(this._renderOrder);
    }
}

