/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile.util;

import com.threerings.media.image.ImageUtil;
import com.threerings.media.tile.TileSet;
import com.threerings.resource.FastImageIO;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class TileSetTrimmer {
    public static void trimTileSet(TileSet source, OutputStream destImage, TrimMetricsReceiver tmr) throws IOException {
        TileSetTrimmer.trimTileSet(source, destImage, tmr, ".raw");
    }

    public static void trimTileSet(TileSet source, OutputStream destImage, TrimMetricsReceiver tmr, String imgFormat) throws IOException {
        int tcount = source.getTileCount();
        BufferedImage[] timgs = new BufferedImage[tcount];
        Rectangle[] tbounds = new Rectangle[tcount];
        int nextx = 0;
        int maxy = 0;
        int ii = 0;
        while (ii < tcount) {
            try {
                timgs[ii] = source.getRawTileImage(ii);
            }
            catch (RasterFormatException rfe) {
                throw new IOException("Failed to get tile image [tidx=" + ii + ", tset=" + source + ", rfe=" + rfe + "].");
            }
            tbounds[ii] = new Rectangle();
            ImageUtil.computeTrimmedBounds(timgs[ii], tbounds[ii]);
            tmr.trimmedTile(ii, nextx, 0, tbounds[ii].x, tbounds[ii].y, tbounds[ii].width, tbounds[ii].height);
            maxy = Math.max(maxy, tbounds[ii].height);
            nextx += tbounds[ii].width;
            ++ii;
        }
        BufferedImage image = null;
        try {
            image = ImageUtil.createCompatibleImage(source.getRawTileSetImage(), nextx, maxy);
        }
        catch (RasterFormatException rfe) {
            throw new IOException("Failed to create trimmed tileset image [wid=" + nextx + ", hei=" + maxy + ", tset=" + source + ", rfe=" + rfe + "].");
        }
        WritableRaster drast = image.getRaster();
        int xoff = 0;
        int ii2 = 0;
        while (ii2 < tcount) {
            Rectangle tb = tbounds[ii2];
            Raster srast = timgs[ii2].getRaster().createChild(tb.x, tb.y, tb.width, tb.height, 0, 0, null);
            drast.setRect(xoff, 0, srast);
            xoff += tb.width;
            ++ii2;
        }
        if (destImage != null) {
            if (imgFormat == null || ".raw".equals(imgFormat)) {
                FastImageIO.write((BufferedImage)image, (OutputStream)destImage);
            } else {
                ImageIO.write((RenderedImage)image, imgFormat, destImage);
            }
        }
    }

    public static interface TrimMetricsReceiver {
        public void trimmedTile(int var1, int var2, int var3, int var4, int var5, int var6, int var7);
    }
}

