/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.image;

import com.threerings.media.image.ImageUtil;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class NinePatch {
    protected final BufferedImage _img;
    protected final int _top;
    protected final int _bottom;
    protected final int _left;
    protected final int _right;
    protected final int _topPad;
    protected final int _bottomPad;
    protected final int _leftPad;
    protected final int _rightPad;

    public NinePatch(BufferedImage img) {
        this(img.getSubimage(1, 1, img.getWidth() - 2, img.getHeight() - 2), NinePatch.getRectangle(img, true), NinePatch.getRectangle(img, false));
    }

    public NinePatch(BufferedImage img, Rectangle center, Rectangle content) {
        this._img = img;
        this._left = center.x;
        this._right = this._img.getWidth() - (center.x + center.width);
        this._top = center.y;
        this._bottom = this._img.getHeight() - (center.y + center.height);
        if (content != null) {
            this._leftPad = content.x;
            this._rightPad = this._img.getWidth() - (content.x + content.width);
            this._topPad = content.y;
            this._bottomPad = this._img.getHeight() - (content.y + content.height);
        } else {
            this._bottomPad = 0;
            this._topPad = 0;
            this._rightPad = 0;
            this._leftPad = 0;
        }
    }

    public void paint(Graphics2D gfx, Rectangle location) {
        int width = this._img.getWidth();
        int height = this._img.getHeight();
        int sw = this._left;
        int sh = this._top;
        int sx = 0;
        int sy = 0;
        int dw = sw;
        int dh = sh;
        int dx = location.x;
        int dy = location.y;
        gfx.drawImage(this._img, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, null);
        sw = this._right;
        sh = this._top;
        sx = width - sw;
        sy = 0;
        dw = sw;
        dh = sh;
        dx = location.x + location.width - dw;
        dy = location.y;
        gfx.drawImage(this._img, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, null);
        sw = this._left;
        sh = this._bottom;
        sx = 0;
        sy = height - sh;
        dw = sw;
        dh = sh;
        dx = location.x;
        dy = location.y + location.height - dh;
        gfx.drawImage(this._img, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, null);
        sw = this._right;
        sh = this._bottom;
        sx = width - sw;
        sy = height - sh;
        dw = sw;
        dh = sh;
        dx = location.x + location.width - dw;
        dy = location.y + location.height - dh;
        gfx.drawImage(this._img, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, null);
        sw = width - this._left - this._right;
        sh = this._top;
        sx = this._left;
        sy = 0;
        dw = location.width - this._left - this._right;
        dh = sh;
        dx = location.x + this._left;
        dy = location.y;
        gfx.drawImage(this._img, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, null);
        sw = width - this._left - this._right;
        sh = this._bottom;
        sx = this._left;
        sy = height - this._bottom;
        dw = location.width - this._left - this._right;
        dh = sh;
        dx = location.x + this._left;
        dy = location.y + location.height - dh;
        gfx.drawImage(this._img, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, null);
        sw = this._left;
        sh = height - this._top - this._bottom;
        sx = 0;
        sy = this._top;
        dw = sw;
        dh = location.height - this._top - this._bottom;
        dx = location.x;
        dy = location.y + this._top;
        gfx.drawImage(this._img, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, null);
        sw = this._right;
        sh = height - this._top - this._bottom;
        sx = width - this._right;
        sy = this._top;
        dw = sw;
        dh = location.height - this._top - this._bottom;
        dx = location.x + location.width - this._right;
        dy = location.y + this._top;
        gfx.drawImage(this._img, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, null);
        sw = width - this._left - this._right;
        sh = height - this._top - this._bottom;
        sx = this._left;
        sy = this._top;
        dw = location.width - this._left - this._right;
        dh = location.height - this._top - this._bottom;
        dx = location.x + this._left;
        dy = location.y + this._top;
        gfx.drawImage(this._img, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, null);
    }

    public Rectangle getBoundsSurrounding(Rectangle content) {
        Rectangle bounds = new Rectangle(content);
        bounds.width += this._leftPad + this._rightPad;
        bounds.height += this._topPad + this._bottomPad;
        bounds.x -= this._leftPad;
        bounds.y -= this._topPad;
        return bounds;
    }

    protected static Rectangle getRectangle(BufferedImage img, boolean stretch) {
        Rectangle rect = new Rectangle(0, 0, img.getWidth() - 2, img.getHeight() - 2);
        int xx = 1;
        while (xx < rect.width + 1) {
            if (ImageUtil.hitTest(img, xx, stretch ? 0 : img.getHeight() - 1)) {
                rect.x = xx - 1;
                rect.width -= rect.x;
                break;
            }
            ++xx;
        }
        xx = img.getWidth() - 1;
        while (xx >= rect.x + 1) {
            if (ImageUtil.hitTest(img, xx, stretch ? 0 : img.getHeight() - 1)) {
                rect.width = xx - rect.x;
                break;
            }
            --xx;
        }
        int yy = 1;
        while (yy < rect.height + 1) {
            if (ImageUtil.hitTest(img, stretch ? 0 : img.getWidth() - 1, yy)) {
                rect.y = yy - 1;
                rect.height -= rect.y;
                break;
            }
            ++yy;
        }
        yy = img.getHeight() - 1;
        while (yy >= rect.y + 1) {
            if (ImageUtil.hitTest(img, stretch ? 0 : img.getWidth() - 1, yy)) {
                rect.height = yy - rect.y;
                break;
            }
            --yy;
        }
        return rect;
    }
}

