/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.image;

import com.threerings.media.image.ImageUtil;
import com.threerings.media.image.Mirage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class BufferedMirage
implements Mirage {
    protected float _percentageOfDataBuffer;
    protected BufferedImage _image;

    public BufferedMirage(BufferedImage image) {
        this(image, 1.0f);
    }

    public BufferedMirage(BufferedImage image, float percentageOfDataBuffer) {
        this._image = image;
        this._percentageOfDataBuffer = percentageOfDataBuffer;
    }

    @Override
    public void paint(Graphics2D gfx, int x, int y) {
        gfx.drawImage((Image)this._image, x, y, null);
    }

    @Override
    public int getWidth() {
        return this._image.getWidth();
    }

    @Override
    public int getHeight() {
        return this._image.getHeight();
    }

    @Override
    public boolean hitTest(int x, int y) {
        return ImageUtil.hitTest(this._image, x, y);
    }

    @Override
    public long getEstimatedMemoryUsage() {
        return (long)((float)ImageUtil.getEstimatedMemoryUsage(this._image.getRaster()) * this._percentageOfDataBuffer);
    }

    @Override
    public BufferedImage getSnapshot() {
        return this._image;
    }
}

