/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.animation;

import com.threerings.media.animation.Animation;
import com.threerings.media.animation.AnimationFrameSequencer;
import com.threerings.media.util.FrameSequencer;
import com.threerings.media.util.MultiFrameImage;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class MultiFrameAnimation
extends Animation {
    protected MultiFrameImage _frames;
    protected FrameSequencer _seeker;
    protected int _fidx;

    public MultiFrameAnimation(MultiFrameImage frames, double fps, boolean loop) {
        this(frames, new FrameSequencer.ConstantRate(fps, loop));
    }

    public MultiFrameAnimation(MultiFrameImage frames, FrameSequencer seeker) {
        super(new Rectangle());
        this._frames = frames;
        this._seeker = seeker;
        this.reset();
    }

    @Override
    public Rectangle getBounds() {
        return this._bounds;
    }

    @Override
    public void reset() {
        super.reset();
        this._fidx = -1;
        this.setFrameIndex(this._seeker.init(this._frames));
        if (this._seeker instanceof AnimationFrameSequencer) {
            ((AnimationFrameSequencer)this._seeker).setAnimation(this);
        }
    }

    @Override
    public void tick(long tickStamp) {
        int fidx = this._seeker.tick(tickStamp);
        if (fidx == -1) {
            this._finished = true;
        } else if (fidx != this._fidx) {
            Rectangle obounds = new Rectangle(this._bounds);
            this.setFrameIndex(fidx);
            this.invalidateAfterChange(obounds);
        }
    }

    protected void setFrameIndex(int fidx) {
        this._fidx = fidx;
        this._bounds.width = this._frames.getWidth(this._fidx);
        this._bounds.height = this._frames.getHeight(this._fidx);
    }

    @Override
    public void paint(Graphics2D gfx) {
        this._frames.paintFrame(gfx, this._fidx, this._bounds.x, this._bounds.y);
    }

    @Override
    public void fastForward(long timeDelta) {
        this._seeker.fastForward(timeDelta);
    }
}

