/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast;

import com.threerings.cast.CompositedActionFrames;
import com.threerings.cast.CompositedMirage;
import com.threerings.cast.CompositedMultiFrameImage;
import com.threerings.cast.TrimmedMultiFrameImage;
import com.threerings.media.image.ImageManager;
import com.threerings.media.image.VolatileMirage;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class CompositedMaskedImage
extends CompositedMultiFrameImage {
    public CompositedMaskedImage(ImageManager imgr, CompositedActionFrames.ComponentFrames[] sources, String action, int orient) {
        super(imgr, sources, action, orient);
    }

    @Override
    public int getWidth(int index) {
        return this._sources[0].frames.getFrames(this._orient).getWidth(index);
    }

    @Override
    public int getHeight(int index) {
        return this._sources[0].frames.getFrames(this._orient).getHeight(index);
    }

    @Override
    public int getXOrigin(int index) {
        return this._sources[0].frames.getXOrigin(this._orient, index);
    }

    @Override
    public int getYOrigin(int index) {
        return this._sources[0].frames.getYOrigin(this._orient, index);
    }

    @Override
    public void paintFrame(Graphics2D g, int index, int x, int y) {
        this._images[index].paint(g, x + this.getX(index), y + this.getY(index));
    }

    @Override
    public boolean hitTest(int index, int x, int y) {
        return this._images[index].hitTest(x + this.getX(index), y + this.getY(index));
    }

    @Override
    public void getTrimmedBounds(int index, Rectangle bounds) {
        bounds.setBounds(this.getX(index), this.getY(index), this._images[index].getWidth(), this._images[index].getHeight());
    }

    @Override
    protected CompositedMirage createCompositedMirage(int index) {
        return new MaskedMirage(index);
    }

    protected int getX(int index) {
        return ((VolatileMirage)((Object)this._images[index])).getX();
    }

    protected int getY(int index) {
        return ((VolatileMirage)((Object)this._images[index])).getY();
    }

    protected class MaskedMirage
    extends CompositedMultiFrameImage.CompositedVolatileMirage {
        public MaskedMirage(int index) {
            super(CompositedMaskedImage.this, index);
        }

        @Override
        protected Rectangle combineBounds(Rectangle bounds, Rectangle tbounds) {
            if (bounds.width == 0 && bounds.height == 0) {
                bounds.setBounds(tbounds);
            } else {
                bounds = bounds.intersection(tbounds);
            }
            return bounds;
        }

        @Override
        protected void refreshVolatileImage() {
            Graphics2D g = (Graphics2D)this._image.getGraphics();
            try {
                TrimmedMultiFrameImage source = CompositedMaskedImage.this._sources[0].frames.getFrames(CompositedMaskedImage.this._orient);
                source.paintFrame(g, this._index, -this._bounds.x, -this._bounds.y);
                g.setComposite(AlphaComposite.DstIn);
                int ii = 1;
                while (ii < CompositedMaskedImage.this._sources.length) {
                    TrimmedMultiFrameImage mask = CompositedMaskedImage.this._sources[ii].frames.getFrames(CompositedMaskedImage.this._orient);
                    mask.paintFrame(g, this._index, -this._bounds.x, -this._bounds.y);
                    ++ii;
                }
            }
            finally {
                if (g != null) {
                    g.dispose();
                }
            }
        }
    }
}

