/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.threerings.openal.Buffer;
import com.threerings.openal.Log;
import com.threerings.openal.SoundManager;
import com.threerings.openal.Source;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public abstract class Stream {
    protected SoundManager _soundmgr;
    protected Source _source;
    protected Buffer[] _buffers = new Buffer[this.getNumBuffers()];
    protected int _qidx;
    protected int _qlen;
    protected float _gain = 1.0f;
    protected float _fadeInterval;
    protected float _fadeElapsed;
    protected FadeMode _fadeMode = FadeMode.NONE;
    protected IntBuffer _nbuf;
    protected ByteBuffer _abuf;
    protected int _state = 4113;

    public Stream(SoundManager soundmgr) {
        this._soundmgr = soundmgr;
        this._source = new Source(soundmgr);
        int ii = 0;
        while (ii < this._buffers.length) {
            this._buffers[ii] = new Buffer(soundmgr);
            ++ii;
        }
        this._soundmgr.addStream(this);
    }

    public void setGain(float gain) {
        this._gain = gain;
        if (this._fadeMode == FadeMode.NONE) {
            this._source.setGain(this._gain);
        }
    }

    public Source getSource() {
        return this._source;
    }

    public boolean isPlaying() {
        return this._state == 4114;
    }

    public void play() {
        if (this._state == 4114) {
            Log.log.warning((Object)"Tried to play stream already playing.", new Object[0]);
            return;
        }
        if (this._state == 4113) {
            this._qlen = 0;
            this._qidx = 0;
            this.queueBuffers(this._buffers.length);
        }
        this._source.play();
        this._state = 4114;
    }

    public void pause() {
        if (this._state != 4114) {
            Log.log.warning((Object)"Tried to pause stream that wasn't playing.", new Object[0]);
            return;
        }
        this._source.pause();
        this._state = 4115;
    }

    public void stop() {
        if (this._state == 4116) {
            Log.log.warning((Object)"Tried to stop stream that was already stopped.", new Object[0]);
            return;
        }
        this._source.stop();
        this._state = 4116;
    }

    public void fadeIn(float interval) {
        if (this._state != 4114) {
            this.play();
        }
        this._source.setGain(0.0f);
        this._fadeMode = FadeMode.IN;
        this._fadeInterval = interval;
        this._fadeElapsed = 0.0f;
    }

    public void fadeOut(float interval, boolean dispose) {
        this._fadeMode = dispose ? FadeMode.OUT_DISPOSE : FadeMode.OUT;
        this._fadeInterval = interval;
        this._fadeElapsed = 0.0f;
    }

    public void dispose() {
        if (this._state != 4116) {
            this.stop();
        }
        this._source.delete();
        Buffer[] bufferArray = this._buffers;
        int n = this._buffers.length;
        int n2 = 0;
        while (n2 < n) {
            Buffer buffer = bufferArray[n2];
            buffer.delete();
            ++n2;
        }
        this._soundmgr.removeStream(this);
    }

    protected void update(float time) {
        this.updateFade(time);
        if (this._state != 4114) {
            return;
        }
        int played = this._source.getBuffersProcessed();
        if (played == 0) {
            return;
        }
        int ii = 0;
        while (ii < played) {
            this._source.unqueueBuffers(this._buffers[this._qidx]);
            this._qidx = (this._qidx + 1) % this._buffers.length;
            --this._qlen;
            ++ii;
        }
        this.queueBuffers(played);
        this._state = this._source.getSourceState();
        if (this._qlen > 0 && this._state != 4114) {
            this.play();
        }
    }

    protected void updateFade(float time) {
        if (this._fadeMode == FadeMode.NONE) {
            return;
        }
        float alpha = Math.min((this._fadeElapsed += time) / this._fadeInterval, 1.0f);
        this._source.setGain(this._gain * (this._fadeMode == FadeMode.IN ? alpha : 1.0f - alpha));
        if (alpha == 1.0f) {
            if (this._fadeMode == FadeMode.OUT) {
                this.stop();
            } else if (this._fadeMode == FadeMode.OUT_DISPOSE) {
                this.dispose();
            }
            this._fadeMode = FadeMode.NONE;
        }
    }

    protected void queueBuffers(int buffers) {
        int ii = 0;
        while (ii < buffers) {
            Buffer buffer = this._buffers[(this._qidx + this._qlen) % this._buffers.length];
            if (!this.populateBuffer(buffer)) break;
            this._source.queueBuffers(buffer);
            ++this._qlen;
            ++ii;
        }
    }

    protected boolean populateBuffer(Buffer buffer) {
        if (this._abuf == null) {
            this._abuf = ByteBuffer.allocateDirect(this.getBufferSize()).order(ByteOrder.nativeOrder());
        }
        this._abuf.clear();
        int read = 0;
        try {
            read = Math.max(this.populateBuffer(this._abuf), 0);
        }
        catch (IOException e) {
            Log.log.warning((Object)("Error reading audio stream [error=" + e + "]."), new Object[0]);
        }
        if (read <= 0) {
            return false;
        }
        this._abuf.rewind().limit(read);
        buffer.setData(this.getFormat(), this._abuf, this.getFrequency());
        return true;
    }

    protected abstract int getFormat();

    protected abstract int getFrequency();

    protected abstract int populateBuffer(ByteBuffer var1) throws IOException;

    protected int getBufferSize() {
        return 262144;
    }

    protected int getNumBuffers() {
        return 4;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FadeMode {
        NONE,
        IN,
        OUT,
        OUT_DISPOSE;

    }
}

