/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile;

import com.threerings.media.image.Colorization;
import com.threerings.media.tile.Tile;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.TrimmedTile;
import com.threerings.media.tile.util.TileSetTrimmer;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.OutputStream;

public class TrimmedTileSet
extends TileSet {
    protected Rectangle[] _obounds;
    protected Rectangle[] _tbounds;
    private static final long serialVersionUID = 1L;

    public int getTileCount() {
        return this._obounds.length;
    }

    public Rectangle computeTileBounds(int tileIndex, Rectangle bounds) {
        bounds.setBounds(this._obounds[tileIndex]);
        return bounds;
    }

    protected Tile createTile() {
        return new TrimmedTile();
    }

    protected void initTile(Tile tile, int tileIndex, Colorization[] zations) {
        super.initTile(tile, tileIndex, zations);
        ((TrimmedTile)tile).setTrimmedBounds(this._tbounds[tileIndex]);
    }

    public static TrimmedTileSet trimTileSet(TileSet source, OutputStream destImage) throws IOException {
        return TrimmedTileSet.trimTileSet(source, destImage, ".raw");
    }

    public static TrimmedTileSet trimTileSet(TileSet source, OutputStream destImage, String imgFormat) throws IOException {
        TrimmedTileSet tset = new TrimmedTileSet();
        tset.setName(source.getName());
        int tcount = source.getTileCount();
        tset._tbounds = new Rectangle[tcount];
        tset._obounds = new Rectangle[tcount];
        int ii = 0;
        while (ii < tcount) {
            tset._tbounds[ii] = source.computeTileBounds(ii, new Rectangle());
            ++ii;
        }
        TileSetTrimmer.TrimMetricsReceiver tmr = new TileSetTrimmer.TrimMetricsReceiver(){

            public void trimmedTile(int tileIndex, int imageX, int imageY, int trimX, int trimY, int trimWidth, int trimHeight) {
                TrimmedTileSet.this._tbounds[tileIndex].x = trimX;
                TrimmedTileSet.this._tbounds[tileIndex].y = trimY;
                TrimmedTileSet.this._obounds[tileIndex] = new Rectangle(imageX, imageY, trimWidth, trimHeight);
            }
        };
        TileSetTrimmer.trimTileSet(source, destImage, tmr, imgFormat);
        return tset;
    }
}

