/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.sprite;

import com.threerings.media.image.Mirage;
import com.threerings.media.sprite.OrientableImageSprite;
import com.threerings.media.util.MultiFrameImage;
import com.threerings.media.util.Path;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;

public class FadableImageSprite
extends OrientableImageSprite {
    protected AlphaComposite _alphaComposite = AlphaComposite.getInstance(3, 1.0f);
    protected long _fadeInDuration = -1L;
    protected long _fadeDelay;
    protected long _fadeStamp = -1L;
    protected long _fadeOutDuration = -1L;
    protected long _pathDuration;

    public FadableImageSprite() {
    }

    public FadableImageSprite(Mirage image) {
        super(image);
    }

    public FadableImageSprite(MultiFrameImage frames) {
        super(frames);
    }

    public void fadeIn(long delay, long duration) {
        this.setAlpha(0.0f);
        this._fadeStamp = 0L;
        this._fadeDelay = delay;
        this._fadeInDuration = duration;
    }

    public void fadeOut(long delay, long duration) {
        this.setAlpha(1.0f);
        this._fadeStamp = 0L;
        this._fadeDelay = delay;
        this._fadeOutDuration = duration;
    }

    public void moveAndFadeIn(Path path, long pathDuration, float fadePortion) {
        this.move(path);
        this.setAlpha(0.0f);
        this._fadeInDuration = (long)((float)pathDuration * fadePortion);
    }

    public void moveAndFadeOut(Path path, long pathDuration, float fadePortion) {
        this.move(path);
        this.setAlpha(1.0f);
        this._fadeStamp = 0L;
        this._pathDuration = pathDuration;
        this._fadeOutDuration = (long)((float)pathDuration * fadePortion);
        this._fadeDelay = this._pathDuration - this._fadeOutDuration;
    }

    public void moveAndFadeInAndOut(Path path, long pathDuration, float fadePortion) {
        this.move(path);
        this.setAlpha(0.0f);
        this._pathDuration = pathDuration;
        this._fadeInDuration = this._fadeOutDuration = (long)((float)pathDuration * fadePortion);
    }

    public void tick(long tickStamp) {
        super.tick(tickStamp);
        if (this._fadeInDuration != -1L) {
            if (this._path != null && tickStamp - this._pathStamp <= this._fadeInDuration) {
                float alpha = (float)(tickStamp - this._pathStamp) / (float)this._fadeInDuration;
                if (alpha >= 1.0f) {
                    this.completeFadeIn();
                } else {
                    this.setAlpha(alpha);
                }
            } else {
                if (this._fadeStamp == 0L) {
                    this._fadeStamp = tickStamp;
                }
                if (tickStamp > this._fadeStamp + this._fadeDelay) {
                    float alpha = (float)(tickStamp - this._fadeStamp - this._fadeDelay) / (float)this._fadeInDuration;
                    if (alpha >= 1.0f) {
                        this.completeFadeIn();
                    } else {
                        this.setAlpha(alpha);
                    }
                }
            }
        } else if (this._fadeOutDuration != -1L) {
            if (this._fadeStamp == 0L) {
                this._fadeStamp = tickStamp;
            }
            if (tickStamp > this._fadeStamp + this._fadeDelay) {
                float alpha = 1.0f - (float)(tickStamp - this._fadeStamp - this._fadeDelay) / (float)this._fadeOutDuration;
                if (alpha <= 0.0f) {
                    this.completeFadeOut();
                } else {
                    this.setAlpha(alpha);
                }
            }
        }
    }

    public void pathCompleted(long timestamp) {
        if (this._fadeInDuration != -1L) {
            this.completeFadeIn();
        } else if (this._fadeOutDuration != -1L) {
            this.completeFadeOut();
        }
        super.pathCompleted(timestamp);
    }

    protected void completeFadeIn() {
        this.setAlpha(1.0f);
        this._fadeInDuration = -1L;
    }

    protected void completeFadeOut() {
        this.setAlpha(0.0f);
        this._fadeOutDuration = -1L;
    }

    public void paint(Graphics2D gfx) {
        if (this._alphaComposite.getAlpha() < 1.0f) {
            Composite ocomp = gfx.getComposite();
            gfx.setComposite(this._alphaComposite);
            super.paint(gfx);
            gfx.setComposite(ocomp);
        } else {
            super.paint(gfx);
        }
    }

    public void setAlpha(float alpha) {
        if (alpha < 0.0f) {
            alpha = 0.0f;
        } else if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        if (alpha != this._alphaComposite.getAlpha()) {
            this._alphaComposite = AlphaComposite.getInstance(3, alpha);
            if (this._mgr != null) {
                this._mgr.getRegionManager().invalidateRegion(this._bounds);
            }
        }
    }

    public float getAlpha() {
        return this._alphaComposite.getAlpha();
    }
}

