/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.animation;

import com.samskivert.util.RandomUtil;
import com.threerings.media.animation.Animation;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class RainAnimation
extends Animation {
    protected static final int DEFAULT_COUNT = 300;
    protected static final int DEFAULT_WIDTH = 13;
    protected static final int DEFAULT_HEIGHT = 10;
    protected int _count;
    protected int _wid;
    protected int _hei;
    protected int[] _drops;
    protected long _duration;
    protected long _end;

    public RainAnimation(Rectangle bounds, long duration) {
        super(bounds);
        this.init(duration, 300, 13, 10);
    }

    public RainAnimation(Rectangle bounds, long duration, int count, int wid, int hei) {
        super(bounds);
        this.init(duration, count, wid, hei);
    }

    protected void init(long duration, int count, int wid, int hei) {
        this._count = count;
        this._wid = wid;
        this._hei = hei;
        this._drops = new int[count];
        this._duration = duration;
    }

    public void tick(long tickStamp) {
        if (this._end == 0L) {
            this._end = tickStamp + this._duration;
        }
        this._finished = tickStamp >= this._end;
        int ii = 0;
        while (ii < this._count) {
            int x = RandomUtil.getInt((int)this._bounds.width);
            int y = RandomUtil.getInt((int)this._bounds.height);
            this._drops[ii] = x << 16 | y;
            ++ii;
        }
        this.invalidate();
    }

    public void fastForward(long timeDelta) {
        this._end += timeDelta;
    }

    public void paint(Graphics2D gfx) {
        gfx.setColor(Color.white);
        int ii = 0;
        while (ii < this._count) {
            int x = this._drops[ii] >> 16;
            int y = this._drops[ii] & 0xFFFF;
            gfx.drawLine(x, y, x + this._wid, y + this._hei);
            ++ii;
        }
    }
}

