/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.animation;

import com.samskivert.util.ObserverList;
import com.threerings.media.animation.Animation;
import com.threerings.media.animation.SequencedAnimationObserver;
import com.threerings.media.util.FrameSequencer;
import com.threerings.media.util.MultiFrameImage;

public interface AnimationFrameSequencer
extends FrameSequencer {
    public void setAnimation(Animation var1);

    public static class MultiFunction
    implements AnimationFrameSequencer {
        protected int _curIdx = 0;
        protected int _length;
        protected boolean _resets = true;
        protected int[] _sequence;
        protected long[] _delays;
        protected long _delay;
        protected boolean[] _marks;
        protected boolean _loop;
        protected long _lastStamp;
        protected Animation _animation;

        public MultiFunction(int[] sequence, long msPerFrame, boolean loop) {
            this._length = sequence.length;
            this._sequence = sequence;
            this.setDelay(msPerFrame);
            this._marks = new boolean[this._length];
            this._loop = loop;
        }

        public MultiFunction(int[] sequence, long[] msPerFrame, boolean[] marks, boolean loop) {
            this._length = sequence.length;
            if (this._length != msPerFrame.length || this._length != marks.length) {
                throw new IllegalArgumentException("All MultiFunction FrameSequencer arrays must be the same length.");
            }
            this._sequence = sequence;
            this._delays = msPerFrame;
            this._marks = marks;
            this._loop = loop;
        }

        public void setDelay(long msPerFrame) {
            this._delays = null;
            this._delay = msPerFrame;
        }

        public void setLength(int len) {
            int n = this._length = len == 0 ? this._sequence.length : len;
            if (this._curIdx >= this._length) {
                this._curIdx = 0;
            }
        }

        public void setResetOnInit(boolean resets) {
            this._resets = resets;
        }

        public int init(MultiFrameImage source) {
            int framecount = source.getFrameCount();
            int ii = 0;
            while (ii < this._length) {
                if (this._sequence[ii] >= framecount) {
                    throw new IllegalArgumentException("MultiFunction FrameSequencer was initialized with a MultiFrameImage with not enough frames to match the sequence it was constructed with.");
                }
                ++ii;
            }
            if (this._resets) {
                this._lastStamp = 0L;
                this._curIdx = 0;
            }
            return this._sequence[this._curIdx];
        }

        public void setAnimation(Animation anim) {
            this._animation = anim;
        }

        public int tick(long tickStamp) {
            if (this._lastStamp == 0L) {
                this._lastStamp = tickStamp;
                this.checkNotify(tickStamp);
            }
            long curdelay = this.getDelay(this._curIdx);
            while (tickStamp >= this._lastStamp + curdelay) {
                this._lastStamp += curdelay;
                ++this._curIdx;
                if (this._curIdx == this._length) {
                    if (this._loop) {
                        this._curIdx = 0;
                    } else {
                        return -1;
                    }
                }
                this.checkNotify(tickStamp);
                curdelay = this.getDelay(this._curIdx);
            }
            return this._sequence[this._curIdx];
        }

        public void fastForward(long timeDelta) {
            this._lastStamp += timeDelta;
        }

        protected final long getDelay(int index) {
            return this._delays == null ? this._delay : this._delays[index];
        }

        protected void checkNotify(long tickStamp) {
            if (this._marks[this._curIdx]) {
                this._animation.queueNotification(new FrameReachedOp(this._animation, tickStamp, this._sequence[this._curIdx], this._curIdx));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class FrameReachedOp
        implements ObserverList.ObserverOp<Object> {
            protected Animation _anim;
            protected long _when;
            protected int _frameIdx;
            protected int _frameSeq;

            public FrameReachedOp(Animation anim, long when, int frameIdx, int frameSeq) {
                this._anim = anim;
                this._when = when;
                this._frameIdx = frameIdx;
                this._frameSeq = frameSeq;
            }

            public boolean apply(Object observer) {
                if (observer instanceof SequencedAnimationObserver) {
                    ((SequencedAnimationObserver)observer).frameReached(this._anim, this._when, this._frameIdx, this._frameSeq);
                }
                return true;
            }
        }
    }
}

