/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.google.common.collect.Lists;
import com.samskivert.util.HashIntMap;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JComboBox;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;

public class KeyDispatcher
implements KeyEventDispatcher,
AncestorListener,
WindowFocusListener {
    protected Window _window;
    protected JTextComponent _curChatGrabber;
    protected LinkedList<JTextComponent> _chatGrabbers = new LinkedList();
    protected ArrayList<KeyListener> _listeners = Lists.newArrayList();
    protected HashIntMap<KeyEvent> _downKeys = new HashIntMap();

    public KeyDispatcher(Window window) {
        this._window = window;
        this._window.addWindowFocusListener(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
    }

    public void shutdown() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this._window.removeWindowFocusListener(this);
    }

    public void pushChatGrabber(JTextComponent comp) {
        this._curChatGrabber = comp;
        this._chatGrabbers.addLast(comp);
        comp.addAncestorListener(this);
        comp.requestFocusInWindow();
    }

    public void removeChatGrabber(JTextComponent comp) {
        comp.removeAncestorListener(this);
        this._chatGrabbers.remove(comp);
        this._curChatGrabber = this._chatGrabbers.isEmpty() ? null : this._chatGrabbers.getLast();
    }

    public void addGlobalKeyListener(KeyListener listener) {
        this._listeners.add(listener);
    }

    public void removeGlobalKeyListener(KeyListener listener) {
        this._listeners.remove(listener);
    }

    public boolean dispatchKeyEvent(KeyEvent e) {
        int lsize = this._listeners.size();
        switch (e.getID()) {
            case 400: {
                int ii = 0;
                while (ii < lsize) {
                    this._listeners.get(ii).keyTyped(e);
                    ++ii;
                }
                if (this._curChatGrabber == null) break;
                Component target = e.getComponent();
                if (!this.isChatCharacter(e.getKeyChar()) || this.isTypeableTarget(target)) break;
                this._curChatGrabber.requestFocusInWindow();
                KeyboardFocusManager.getCurrentKeyboardFocusManager().redispatchEvent(this._curChatGrabber, e);
                return true;
            }
            case 401: {
                if (lsize <= 0) break;
                int ii = 0;
                while (ii < lsize) {
                    this._listeners.get(ii).keyPressed(e);
                    ++ii;
                }
                this._downKeys.put(e.getKeyCode(), (Object)e);
                break;
            }
            case 402: {
                if (lsize <= 0) break;
                int ii = 0;
                while (ii < lsize) {
                    this._listeners.get(ii).keyReleased(e);
                    ++ii;
                }
                this._downKeys.remove(e.getKeyCode());
            }
        }
        return false;
    }

    protected boolean isTypeableTarget(Component target) {
        return target.isShowing() && (target instanceof JTextComponent && ((JTextComponent)target).isEditable() || target instanceof JComboBox || target instanceof JTable || target instanceof JRootPane);
    }

    protected boolean isChatCharacter(char c) {
        return Character.isLetterOrDigit(c) || '/' == c;
    }

    public void windowGainedFocus(WindowEvent e) {
    }

    public void windowLostFocus(WindowEvent e) {
        if (!this._downKeys.isEmpty()) {
            long now = System.currentTimeMillis();
            for (KeyEvent down : this._downKeys.values()) {
                KeyEvent up = new KeyEvent(down.getComponent(), 402, now, down.getModifiers(), down.getKeyCode(), down.getKeyChar(), down.getKeyLocation());
                int ii = 0;
                int nn = this._listeners.size();
                while (ii < nn) {
                    this._listeners.get(ii).keyReleased(up);
                    ++ii;
                }
            }
            this._downKeys.clear();
        }
    }

    public void ancestorAdded(AncestorEvent ae) {
    }

    public void ancestorMoved(AncestorEvent ae) {
    }

    public void ancestorRemoved(AncestorEvent ae) {
        this.removeChatGrabber((JTextComponent)ae.getComponent());
    }
}

