/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.tile;

import com.google.common.collect.Lists;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;

public class FringeConfiguration
implements Serializable {
    public static final String CONFIG_PATH = "config/miso/tile/fringeconf.dat";
    protected HashIntMap<FringeRecord> _frecs = new HashIntMap();
    private static final long serialVersionUID = 1L;

    public void addFringeRecord(FringeRecord frec) {
        this._frecs.put(frec.base_tsid, (Object)frec);
    }

    public int fringesOn(int first, int second) {
        FringeRecord f2;
        FringeRecord f1 = (FringeRecord)this._frecs.get(first);
        if (f1 != null && f1.tilesets.size() > 0 && ((f2 = (FringeRecord)this._frecs.get(second)) == null || f1.priority > f2.priority)) {
            return f1.priority;
        }
        return -1;
    }

    public FringeTileSetRecord getFringe(int baseset, int hashValue) {
        FringeRecord f = (FringeRecord)this._frecs.get(baseset);
        return f.tilesets.get(hashValue % f.tilesets.size());
    }

    public static class FringeRecord
    implements Serializable {
        public int base_tsid;
        public int priority;
        public ArrayList<FringeTileSetRecord> tilesets = Lists.newArrayList();
        private static final long serialVersionUID = 1L;

        public void addTileset(FringeTileSetRecord record) {
            this.tilesets.add(record);
        }

        public boolean isValid() {
            return this.base_tsid != 0 && this.priority > 0;
        }

        public String toString() {
            return "[base_tsid=" + this.base_tsid + ", priority=" + this.priority + ", tilesets=" + StringUtil.toString(this.tilesets) + "]";
        }
    }

    public static class FringeTileSetRecord
    implements Serializable {
        public int fringe_tsid;
        public boolean mask;
        private static final long serialVersionUID = 1L;

        public boolean isValid() {
            return this.fringe_tsid != 0;
        }

        public String toString() {
            return "[fringe_tsid=" + this.fringe_tsid + ", mask=" + this.mask + "]";
        }
    }
}

