/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.data;

import com.samskivert.util.StringUtil;
import com.threerings.io.SimpleStreamableObject;
import com.threerings.media.tile.TileUtil;

public class ObjectInfo
extends SimpleStreamableObject
implements Cloneable {
    public int tileId;
    public int x;
    public int y;
    public byte priority = 0;
    public String action;
    public byte sx;
    public byte sy;
    public byte sorient;
    public int zations;

    public ObjectInfo(int tileId, int x, int y) {
        this.tileId = tileId;
        this.x = x;
        this.y = y;
    }

    public ObjectInfo(ObjectInfo other) {
        this.tileId = other.tileId;
        this.x = other.x;
        this.y = other.y;
        this.priority = other.priority;
        this.action = other.action;
        this.sx = other.sx;
        this.sy = other.sy;
        this.sorient = other.sorient;
        this.zations = other.zations;
    }

    public ObjectInfo() {
    }

    public int getPriority() {
        return this.priority;
    }

    public int getPrimaryZation() {
        return this.zations & 0xFF;
    }

    public int getSecondaryZation() {
        return this.zations >> 16 & 0xFF;
    }

    public int getTertiaryZation() {
        return this.zations >> 24 & 0xFF;
    }

    public int getQuaternaryZation() {
        return this.zations >> 8 & 0xFF;
    }

    public void setZations(byte primary, byte secondary, byte tertiary, byte quaternary) {
        this.zations = primary | secondary << 16 | tertiary << 24 | quaternary << 8;
    }

    public boolean isInteresting() {
        return !StringUtil.isBlank((String)this.action) || this.priority != 0 || this.sx != 0 || this.sy != 0 || this.zations != 0;
    }

    public boolean equals(Object other) {
        if (other instanceof ObjectInfo) {
            ObjectInfo ooi = (ObjectInfo)other;
            return this.x == ooi.x && this.y == ooi.y && this.tileId == ooi.tileId;
        }
        return false;
    }

    public int hashCode() {
        return this.x ^ this.y ^ this.tileId;
    }

    public ObjectInfo clone() {
        try {
            return (ObjectInfo)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new AssertionError((Object)cnse);
        }
    }

    public String tileIdToString() {
        return String.valueOf(TileUtil.getTileSetId(this.tileId)) + ":" + TileUtil.getTileIndex(this.tileId);
    }
}

