/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.util;

import com.threerings.media.Log;
import com.threerings.media.util.Path;
import com.threerings.media.util.Pathable;

public abstract class TimedPath
implements Path {
    protected long _duration;
    protected long _startStamp;

    public TimedPath(long duration) {
        if (duration <= 0L) {
            Log.log.warning((Object)"Requested path with illegal duration (<=0)", new Object[]{"duration", duration, new Exception()});
            duration = 1L;
        }
        this._duration = duration;
    }

    public void init(Pathable pable, long timestamp) {
        pable.pathBeginning();
        this._startStamp = timestamp;
    }

    public void fastForward(long timeDelta) {
        this._startStamp += timeDelta;
    }

    public void wasRemoved(Pathable pable) {
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        this.toString(buf);
        return buf.append("]").toString();
    }

    protected void toString(StringBuilder buf) {
        buf.append("duration=").append(this._duration).append("ms");
    }
}

