/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.util;

import com.samskivert.util.HashIntMap;
import com.threerings.media.util.MathUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BStarPathUtil {
    protected static boolean considerStep(Info info, Node n, int x, int y) {
        if (!info.isStepValid(n.x, n.y, x, y)) {
            return false;
        }
        Node np = info.getNode(x, y);
        if (np.closed || info.open.contains(np)) {
            return false;
        }
        info.open.remove(np);
        np.parent = n;
        np.h = BStarPathUtil.getDistanceEstimate(np.x, np.y, info.destx, info.desty);
        np.f = np.g + np.h;
        np.closed = false;
        info.open.add(np);
        return true;
    }

    protected static int getDistanceEstimate(int ax, int ay, int bx, int by) {
        int xsq = bx - ax;
        int ysq = by - ay;
        return (int)Math.sqrt(xsq * xsq + ysq * ysq);
    }

    public static List<Point> getPath(TraversalPred tpred, Stepper stepper, Object trav, int longest, int ax, int ay, int bx, int by, boolean partial) {
        Info info = new Info(tpred, trav, longest, bx, by);
        Node s = info.getNode(ax, ay);
        s.g = 0;
        s.h = BStarPathUtil.getDistanceEstimate(ax, ay, bx, by);
        s.f = s.g + s.h;
        info.open.add(s);
        float bestdist = Float.MAX_VALUE;
        Node bestpath = null;
        while (info.open.size() > 0) {
            Iterator<Node> it = info.open.iterator();
            while (it.hasNext()) {
                float pathdist;
                Node n = it.next();
                if (n.x == bx && n.y == by) {
                    return BStarPathUtil.getNodePath(n);
                }
                if (partial && (pathdist = MathUtil.distance(n.x, n.y, bx, by)) < bestdist) {
                    bestdist = pathdist;
                    bestpath = n;
                }
                stepper.init(info, n);
                stepper.considerSteps(n.x, n.y);
                if (n.status == Status.CLOSE || n.status == Status.CRAWLING) {
                    it.remove();
                    n.closed = true;
                    continue;
                }
                if (n.status != Status.DIVARICATION) continue;
                it.remove();
            }
        }
        if (bestpath != null) {
            return BStarPathUtil.getNodePath(bestpath);
        }
        return null;
    }

    private static List<Point> getNodePath(Node n) {
        return null;
    }

    public static class Branch {
        private Info info;
        public Branch left;
        public Branch right;
        public List<Node> nodes = new ArrayList<Node>();
        public Node current;
        public Branch parent;
        public boolean closed;

        public Branch(Info info, Branch parent, Node current) {
            this.info = info;
            this.parent = parent;
            this.current = current;
            this.nodes.add(current);
        }
    }

    protected static class Info {
        public TraversalPred tpred;
        public int tilewid;
        public int tilehei;
        public Object trav;
        public Set<Node> open;
        public int destx;
        public int desty;
        protected HashIntMap<Node> _nodes = new HashIntMap();

        public Info(TraversalPred tpred, Object trav, int longest, int destx, int desty) {
            this.tpred = tpred;
            this.trav = trav;
            this.destx = destx;
            this.desty = desty;
            this.open = new TreeSet<Node>();
        }

        protected boolean isStepValid(int sx, int sy, int dx, int dy) {
            if (!this.isTraversable(dx, dy)) {
                return false;
            }
            if (Math.abs(dx - sx) == 1 && Math.abs(dy - sy) == 1) {
                return this.isTraversable(dx, sy) && this.isTraversable(sx, dy);
            }
            return true;
        }

        protected boolean isTraversable(int x, int y) {
            return this.tpred.canTraverse(this.trav, x, y);
        }

        public Node getNode(int x, int y) {
            int key = x << 16 | y & 0xFFFF;
            Node node = (Node)this._nodes.get(key);
            if (node == null) {
                node = new Node(x, y);
                this._nodes.put(key, (Object)node);
            }
            return node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node
    implements Comparable<Node> {
        public int x;
        public int y;
        public int g;
        public int h;
        public int f;
        public Node parent;
        public int id;
        public Node left;
        public Node right;
        public Status status;
        public boolean closed;
        protected static int _nextid = 0;

        public Node(int x, int y) {
            this.x = x;
            this.y = y;
            this.id = _nextid++;
        }

        @Override
        public int compareTo(Node o) {
            int bf = o.f;
            if (this.f == bf) {
                return this == o ? 0 : this.id - o.id;
            }
            return this.f - bf;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NONE,
        CRAWLING,
        DIVARICATION,
        CLOSE;

    }

    public static class Stepper {
        protected boolean _considerDiagonals;
        protected Info _info;
        protected Node _node;

        public Stepper() {
            this(true);
        }

        public Stepper(boolean considerDiagonals) {
            this._considerDiagonals = considerDiagonals;
        }

        public void init(Info info, Node n) {
            this._info = info;
            this._node = n;
        }

        public void considerSteps(int x, int y) {
            if (this._node.parent != null) {
                boolean bl = this.considerStep(2 * x - this._node.parent.x, 2 * y - this._node.parent.y);
            } else {
                Math.abs(x - this._info.destx);
                Math.abs(y - this._info.desty);
            }
            this.considerStep(x, y - 1);
            this.considerStep(x, y + 1);
            this.considerStep(x - 1, y);
            this.considerStep(x + 1, y);
        }

        protected boolean considerStep(int x, int y) {
            if (this._node.parent != null && this._node.parent.x == x && this._node.parent.y == y) {
                return false;
            }
            boolean result = BStarPathUtil.considerStep(this._info, this._node, x, y);
            return result;
        }
    }

    public class Tetrad {
        int x;
        int y;
        boolean b;
    }

    public static interface TraversalPred {
        public boolean canTraverse(Object var1, int var2, int var3);
    }
}

