/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile;

import com.samskivert.util.StringUtil;
import com.threerings.media.tile.TileSet;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;

public class SwissArmyTileSet
extends TileSet {
    protected int[] _tileCounts;
    protected int _numTiles;
    protected int[] _widths;
    protected int[] _heights;
    protected Point _offsetPos = new Point();
    protected Dimension _gapSize = new Dimension();
    private static final long serialVersionUID = 1L;

    public int getTileCount() {
        return this._numTiles;
    }

    public Rectangle computeTileBounds(int tileIndex, Rectangle bounds) {
        int tcount = 0;
        int ridx = 0;
        int tx = this._offsetPos.x;
        int ty = this._offsetPos.y;
        while ((tcount += this._tileCounts[ridx]) < tileIndex + 1) {
            ty += this._heights[ridx++] + this._gapSize.height;
        }
        int xidx = tileIndex - (tcount - this._tileCounts[ridx]);
        bounds.setBounds(tx += xidx * (this._widths[ridx] + this._gapSize.width), ty, this._widths[ridx], this._heights[ridx]);
        return bounds;
    }

    public void setTileCounts(int[] tileCounts) {
        this._tileCounts = tileCounts;
        this.computeTileCount();
    }

    public int[] getTileCounts() {
        return this._tileCounts;
    }

    protected void computeTileCount() {
        this._numTiles = 0;
        int[] nArray = this._tileCounts;
        int n = this._tileCounts.length;
        int n2 = 0;
        while (n2 < n) {
            int count = nArray[n2];
            this._numTiles += count;
            ++n2;
        }
    }

    public void setWidths(int[] widths) {
        this._widths = widths;
    }

    public int[] getWidths() {
        return this._widths;
    }

    public void setHeights(int[] heights) {
        this._heights = heights;
    }

    public int[] getHeights() {
        return this._heights;
    }

    public void setOffsetPos(Point offsetPos) {
        this._offsetPos = offsetPos;
    }

    public void setGapSize(Dimension gapSize) {
        this._gapSize = gapSize;
    }

    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", widths=").append(StringUtil.toString((Object)this._widths));
        buf.append(", heights=").append(StringUtil.toString((Object)this._heights));
        buf.append(", tileCounts=").append(StringUtil.toString((Object)this._tileCounts));
        buf.append(", offsetPos=").append(StringUtil.toString((Object)this._offsetPos));
        buf.append(", gapSize=").append(StringUtil.toString((Object)this._gapSize));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.computeTileCount();
    }
}

