/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast;

import com.samskivert.util.StringUtil;
import com.threerings.cast.ActionFrames;
import com.threerings.cast.CharacterComponent;
import com.threerings.cast.CompositedMultiFrameImage;
import com.threerings.cast.TrimmedMultiFrameImage;
import com.threerings.media.image.Colorization;
import com.threerings.media.image.ImageManager;
import com.threerings.util.DirectionCodes;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositedActionFrames
implements ActionFrames,
DirectionCodes {
    protected ImageManager _imgr;
    protected Map<CompositedFramesKey, CompositedMultiFrameImage> _frameCache;
    protected String _action;
    protected int _orientCount;
    protected ComponentFrames[] _sources;
    protected CompositedFramesKey _key = new CompositedFramesKey(0);

    public CompositedActionFrames(ImageManager imgr, Map<CompositedFramesKey, CompositedMultiFrameImage> frameCache, String action, ComponentFrames[] sources) {
        if (sources == null || sources.length == 0) {
            String errmsg = "Requested to composite invalid set of source frames! [action=" + action + ", sources=" + StringUtil.toString((Object)sources) + "].";
            throw new RuntimeException(errmsg);
        }
        this._imgr = imgr;
        this._frameCache = frameCache;
        this._sources = sources;
        this._action = action;
        this._orientCount = this._sources[0].frames.getOrientationCount();
    }

    @Override
    public int getOrientationCount() {
        return this._orientCount;
    }

    @Override
    public TrimmedMultiFrameImage getFrames(int orient) {
        this._key.setOrient(orient);
        CompositedMultiFrameImage cmfi = this._frameCache.get(this._key);
        if (cmfi == null) {
            cmfi = this.createFrames(orient);
            this._frameCache.put(new CompositedFramesKey(orient), cmfi);
        }
        return cmfi;
    }

    @Override
    public int getXOrigin(int orient, int frameIdx) {
        CompositedMultiFrameImage cmfi = (CompositedMultiFrameImage)this.getFrames(orient);
        return cmfi.getXOrigin(frameIdx);
    }

    @Override
    public int getYOrigin(int orient, int frameIdx) {
        CompositedMultiFrameImage cmfi = (CompositedMultiFrameImage)this.getFrames(orient);
        return cmfi.getYOrigin(frameIdx);
    }

    @Override
    public ActionFrames cloneColorized(Colorization[] zations) {
        throw new RuntimeException("What you talkin' about Willis?");
    }

    @Override
    public ActionFrames cloneTranslated(int dx, int dy) {
        ComponentFrames[] tsources = new ComponentFrames[this._sources.length];
        int ii = 0;
        while (ii < this._sources.length) {
            tsources[ii] = new ComponentFrames(this._sources[ii].ccomp, this._sources[ii].frames.cloneTranslated(dx, dy));
            ++ii;
        }
        return new CompositedActionFrames(this._imgr, this._frameCache, this._action, tsources);
    }

    protected CompositedMultiFrameImage createFrames(int orient) {
        return new CompositedMultiFrameImage(this._imgr, this._sources, this._action, orient);
    }

    public static class ComponentFrames {
        public CharacterComponent ccomp;
        public ActionFrames frames;

        public ComponentFrames() {
        }

        public ComponentFrames(CharacterComponent ccomp, ActionFrames frames) {
            this.ccomp = ccomp;
            this.frames = frames;
        }

        public String toString() {
            return this.ccomp + ":" + this.frames;
        }
    }

    protected class CompositedFramesKey {
        protected int _orient;

        public CompositedFramesKey(int orient) {
            this._orient = orient;
        }

        public void setOrient(int orient) {
            this._orient = orient;
        }

        public CompositedActionFrames getOwner() {
            return CompositedActionFrames.this;
        }

        public boolean equals(Object other) {
            CompositedFramesKey okey = (CompositedFramesKey)other;
            return this.getOwner() == okey.getOwner() && this._orient == okey._orient;
        }

        public int hashCode() {
            return CompositedActionFrames.this.hashCode() ^ this._orient;
        }
    }
}

