/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast;

import com.samskivert.util.ArrayIntSet;
import com.samskivert.util.ComparableArrayList;
import com.samskivert.util.StringUtil;
import java.io.Serializable;

public class ComponentClass
implements Serializable {
    public String name;
    public int renderPriority;
    public String[] colors;
    public String mask;
    public String shadow;
    public float shadowAlpha = 1.0f;
    public boolean translate;
    protected ComparableArrayList<PriorityOverride> _overrides;
    private static final long serialVersionUID = 4L;

    @Deprecated
    public int getRenderPriority(String action, int orientation) {
        return this.getRenderPriority(action, null, orientation);
    }

    public int getRenderPriority(String action, String component, int orientation) {
        int ocount = this._overrides != null ? this._overrides.size() : 0;
        int ii = 0;
        while (ii < ocount) {
            PriorityOverride over = (PriorityOverride)this._overrides.get(ii);
            if (over.matches(action, component, orientation)) {
                return over.renderPriority;
            }
            ++ii;
        }
        return this.renderPriority;
    }

    public void addPriorityOverride(PriorityOverride override) {
        if (this._overrides == null) {
            this._overrides = new ComparableArrayList();
        }
        this._overrides.insertSorted((Comparable)override);
    }

    public boolean isShadowed() {
        return this.shadow != null;
    }

    public boolean isShadow() {
        return this.shadowAlpha != 1.0f;
    }

    public boolean equals(Object other) {
        if (other instanceof ComponentClass) {
            return this.name.equals(((ComponentClass)other).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        buf.append("name=").append(this.name);
        buf.append(", pri=").append(this.renderPriority);
        if (this.colors != null) {
            buf.append(", colors=").append(StringUtil.toString((Object)this.colors));
        }
        if (this.mask != null) {
            buf.append(", mask=").append(this.mask);
        }
        if (this.shadowAlpha != 1.0f) {
            buf.append(", shadow=").append(this.shadowAlpha);
        } else if (this.shadow != null) {
            buf.append(", shadow=").append(this.shadow);
        }
        return buf.append("]").toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PriorityOverride
    implements Comparable<PriorityOverride>,
    Serializable {
        public int renderPriority;
        public String action;
        public String component;
        public ArrayIntSet orients;
        private static final long serialVersionUID = 1L;

        public boolean matches(String action, String component, int orient) {
            return !(this.orients != null && !this.orients.contains(orient) || this.component != null && !this.component.equals(component) || this.action != null && !this.action.equals(action));
        }

        @Override
        public int compareTo(PriorityOverride po) {
            int opri;
            int pri = this.priority();
            if (pri == (opri = po.priority())) {
                return this.hashCode() - po.hashCode();
            }
            return pri - opri;
        }

        protected int priority() {
            int priority = 0;
            if (this.component != null) {
                priority += 3;
            }
            if (this.action != null) {
                ++priority;
            }
            if (this.orients != null) {
                ++priority;
            }
            return priority;
        }

        public String toString() {
            return "[pri=" + this.renderPriority + ", action=" + this.action + ", component=" + this.component + ", orients=" + this.orients + "]";
        }
    }
}

