/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.openal;

import com.google.common.collect.Maps;
import com.threerings.openal.Log;
import com.threerings.openal.Mp3StreamDecoder;
import com.threerings.openal.OggStreamDecoder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StreamDecoder {
    protected static HashMap<String, Class<? extends StreamDecoder>> _extensions = Maps.newHashMap();

    public static void registerExtension(String extension, Class<? extends StreamDecoder> clazz) {
        _extensions.put(extension, clazz);
    }

    public static StreamDecoder createInstance(File file) throws IOException {
        return StreamDecoder.createInstance(file.toURI().toURL());
    }

    public static StreamDecoder createInstance(URL url) throws IOException {
        StreamDecoder decoder;
        String path = url.getPath();
        int idx = path.lastIndexOf(46);
        if (idx == -1) {
            Log.log.warning((Object)"Missing extension for URL.", new Object[]{"url", url});
            return null;
        }
        String extension = path.substring(idx + 1);
        Class<? extends StreamDecoder> clazz = _extensions.get(extension);
        if (clazz == null) {
            Log.log.warning((Object)"No decoder registered for extension.", new Object[]{"extension", extension, "url", url});
            return null;
        }
        try {
            decoder = clazz.newInstance();
        }
        catch (Exception e) {
            Log.log.warning((Object)"Error instantiating decoder.", new Object[]{"url", url, e});
            return null;
        }
        decoder.init(url.openStream());
        return decoder;
    }

    public abstract void init(InputStream var1) throws IOException;

    public abstract int getFormat();

    public abstract int getFrequency();

    public abstract int read(ByteBuffer var1) throws IOException;

    static {
        StreamDecoder.registerExtension("ogg", OggStreamDecoder.class);
        StreamDecoder.registerExtension("mp3", Mp3StreamDecoder.class);
    }
}

