/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.samskivert.swing.Controller;
import com.samskivert.swing.RadialMenu;
import com.samskivert.swing.RuntimeAdjust;
import com.samskivert.swing.event.CommandEvent;
import com.samskivert.util.StringUtil;
import com.threerings.media.VirtualMediaPanel;
import com.threerings.media.sprite.Sprite;
import com.threerings.media.tile.TileManager;
import com.threerings.media.tile.TileSet;
import com.threerings.media.util.AStarPathUtil;
import com.threerings.media.util.MathUtil;
import com.threerings.media.util.Path;
import com.threerings.miso.Log;
import com.threerings.miso.MisoPrefs;
import com.threerings.miso.client.DirtyItemList;
import com.threerings.miso.client.ObjectActionHandler;
import com.threerings.miso.client.ResolutionView;
import com.threerings.miso.client.RethinkOp;
import com.threerings.miso.client.SceneBlock;
import com.threerings.miso.client.SceneBlockResolver;
import com.threerings.miso.client.SceneObject;
import com.threerings.miso.client.SceneObjectActionEvent;
import com.threerings.miso.client.SceneObjectIndicator;
import com.threerings.miso.client.SceneObjectTip;
import com.threerings.miso.client.TileOp;
import com.threerings.miso.client.TileOpApplicator;
import com.threerings.miso.client.TilePath;
import com.threerings.miso.data.MisoSceneModel;
import com.threerings.miso.data.ObjectInfo;
import com.threerings.miso.tile.AutoFringer;
import com.threerings.miso.tile.BaseTile;
import com.threerings.miso.util.MisoContext;
import com.threerings.miso.util.MisoSceneMetrics;
import com.threerings.miso.util.MisoUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MisoScenePanel
extends VirtualMediaPanel
implements MouseListener,
MouseMotionListener,
AStarPathUtil.TraversalPred,
RadialMenu.Host {
    public static final int SHOW_TIPS = 1;
    protected MisoContext _ctx;
    protected MisoSceneMetrics _metrics;
    protected MisoSceneModel _model;
    protected Dimension _rsize = new Dimension();
    protected Point _ulpos;
    protected Rectangle _ibounds = new Rectangle();
    protected Rectangle _vibounds = new Rectangle();
    protected RethinkOp _rethinkOp;
    protected ConcurrentHashMap<Integer, SceneBlock> _blocks = new ConcurrentHashMap();
    protected int _pendingBlocks;
    protected Set<SceneBlock> _visiBlocks = Sets.newHashSet();
    protected boolean _delayRepaint = false;
    protected List<SceneObject> _vizobjs = Lists.newArrayList();
    protected Map<Long, BufferedImage> _masks = Maps.newHashMap();
    protected Map<AutoFringer.FringeTile, WeakReference<AutoFringer.FringeTile>> _fringes = new WeakHashMap<AutoFringer.FringeTile, WeakReference<AutoFringer.FringeTile>>();
    protected DirtyItemList _dirtyItems = new DirtyItemList();
    protected List<Sprite> _dirtySprites = Lists.newArrayList();
    protected PaintTileOp _paintOp = new PaintTileOp();
    protected Point _tcoords = new Point();
    protected List<Sprite> _hitSprites = Lists.newArrayList();
    protected DirtyItemList _hitList = new DirtyItemList();
    protected Object _hobject;
    protected Object _armedItem = null;
    protected RadialMenu _activeMenu;
    protected Point _hcoords = new Point();
    protected Map<SceneObject, SceneObjectIndicator> _indicators = Maps.newHashMap();
    protected boolean _indicatorsLaidOut = false;
    protected int _showFlags = 0;
    protected SceneBlockResolver _resolver;
    protected static Map<MisoContext, SceneBlockResolver> _resolvers = new WeakHashMap<MisoContext, SceneBlockResolver>();
    protected JFrame _dframe;
    protected ResolutionView _dpanel;
    protected TileOpApplicator _applicator;
    protected static RuntimeAdjust.BooleanAdjust _traverseDebug = new RuntimeAdjust.BooleanAdjust("Toggles debug rendering of traversable and impassable tiles in the iso scene view.", "narya.miso.iso_traverse_debug_render", MisoPrefs.config, false);
    protected static RuntimeAdjust.BooleanAdjust _coordsDebug = new RuntimeAdjust.BooleanAdjust("Toggles debug rendering of tile coordinates in the iso scene view.", "narya.miso.iso_coords_debug_render", MisoPrefs.config, false);
    protected static RuntimeAdjust.BooleanAdjust _pathsDebug = new RuntimeAdjust.BooleanAdjust("Toggles debug rendering of sprite paths in the iso scene view.", "narya.miso.iso_paths_debug_render", MisoPrefs.config, false);
    protected static RuntimeAdjust.BooleanAdjust _resolveDebug = new RuntimeAdjust.BooleanAdjust("Enables a view displaying the status of scene block resolution.", "narya.miso.iso_paths_debug_resolve", MisoPrefs.config, false);
    protected static final Stroke DIRTY_RECT_STROKE = new BasicStroke(2.0f);
    protected static final Composite ALPHA_FILL_TILE = AlphaComposite.getInstance(3, 0.5f);
    protected static final Dimension DEF_RADIAL_RECT = new Dimension(80, 80);

    public MisoScenePanel(MisoContext ctx, MisoSceneMetrics metrics) {
        super(ctx.getFrameManager());
        this._ctx = ctx;
        this._metrics = metrics;
        this._rethinkOp = new RethinkOp(this._metrics);
        this._applicator = new TileOpApplicator(this._metrics);
        this.setOpaque(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this._resolver = _resolvers.get(this._ctx);
        if (this._resolver == null) {
            this._resolver = new SceneBlockResolver();
            this._resolver.setDaemon(true);
            this._resolver.setPriority(1);
            this._resolver.start();
            _resolvers.put(this._ctx, this._resolver);
        }
    }

    public void setSceneModel(MisoSceneModel model) {
        this._model = model;
        this.clearScene();
        this.centerOnTile(0, 0);
        if (this.isShowing()) {
            this.rethink();
            this._remgr.invalidateRegion(this._vbounds);
        }
    }

    protected void clearScene() {
        this._blocks.clear();
        this._vizobjs.clear();
        this._fringes.clear();
        this._masks.clear();
        if (this._dpanel != null) {
            this._dpanel.newScene();
        }
    }

    public void refreshScene() {
        this.clearScene();
        this._delayRepaint = this.rethink() > 0;
        this._remgr.invalidateRegion(this._vbounds);
    }

    public void centerOnTile(int tx, int ty) {
        Rectangle trect = MisoUtil.getTilePolygon(this._metrics, tx, ty).getBounds();
        int nx = trect.x + trect.width / 2 - this._vbounds.width / 2;
        int ny = trect.y + trect.height / 2 - this._vbounds.height / 2;
        this.setViewLocation(nx, ny);
    }

    public MisoSceneModel getSceneModel() {
        return this._model;
    }

    public MisoSceneMetrics getSceneMetrics() {
        return this._metrics;
    }

    public void setShowFlags(int flags, boolean on) {
        int oldshow = this._showFlags;
        this._showFlags = on ? (this._showFlags |= flags) : (this._showFlags &= ~flags);
        if (oldshow != this._showFlags) {
            this.showFlagsDidChange(oldshow);
        }
    }

    public boolean checkShowFlag(int flag) {
        return 0 != (flag & this._showFlags);
    }

    protected void showFlagsDidChange(int oldflags) {
        if ((oldflags & 1) != (this._showFlags & 1)) {
            for (SceneObjectIndicator indic : this._indicators.values()) {
                this.dirtyIndicator(indic);
            }
        }
    }

    public Object getHoverObject() {
        return this._hobject;
    }

    public Point getHoverCoords() {
        return this._hcoords;
    }

    public Iterator<SceneBlock> enumerateResolvedBlocks() {
        return this._blocks.values().iterator();
    }

    public SceneBlock getBlock(int tx, int ty) {
        int bx = MathUtil.floorDiv(tx, this._metrics.blockwid);
        int by = MathUtil.floorDiv(ty, this._metrics.blockhei);
        return this._blocks.get(MisoScenePanel.compose(bx, by));
    }

    public Path getPath(Sprite sprite, int x, int y, boolean loose) {
        if (sprite == null) {
            throw new IllegalArgumentException("Can't get path for null sprite [x=" + x + ", y=" + y + ".");
        }
        Point src = MisoUtil.screenToTile(this._metrics, sprite.getX(), sprite.getY(), new Point());
        Point dest = MisoUtil.screenToTile(this._metrics, x, y, new Point());
        int longestPath = 3 * (this.getWidth() / this._metrics.tilewid);
        long start = System.currentTimeMillis();
        List<Point> points = AStarPathUtil.getPath(this, sprite, longestPath, src.x, src.y, dest.x, dest.y, loose);
        long duration = System.currentTimeMillis() - start;
        if (duration > 500L) {
            int considered = AStarPathUtil.getConsidered();
            Log.log.warning((Object)("Considered " + considered + " nodes for path from " + StringUtil.toString((Object)src) + " to " + StringUtil.toString((Object)dest) + " [duration=" + duration + "]."), new Object[0]);
        }
        return points == null ? null : new TilePath(this._metrics, sprite, points, x, y);
    }

    public Point getScreenCoords(int x, int y) {
        return MisoUtil.fullToScreen(this._metrics, x, y, new Point());
    }

    public Point getFullCoords(int x, int y) {
        return MisoUtil.screenToFull(this._metrics, x, y, new Point());
    }

    public Point getTileCoords(int x, int y) {
        return MisoUtil.screenToTile(this._metrics, x, y, new Point());
    }

    public void clearRadialMenu() {
        if (this._activeMenu != null) {
            this._activeMenu.deactivate();
        }
    }

    public void reportMemoryUsage() {
        HashMap base = Maps.newHashMap();
        HashSet fringe = Sets.newHashSet();
        HashMap object = Maps.newHashMap();
        long[] usage = new long[3];
        for (SceneBlock block : this._blocks.values()) {
            block.computeMemoryUsage(base, fringe, object, usage);
        }
        Log.log.info((Object)"Scene tile memory usage", new Object[]{"scene", StringUtil.shortClassName((Object)this), "base", base.size() + "->" + usage[0] / 1024L + "k", "fringe", fringe.size() + "->" + usage[1] / 1024L + "k", "obj", object.size() + "->" + usage[2] / 1024L + "k"});
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (_resolveDebug.getValue()) {
            this._dpanel = new ResolutionView(this);
            this._dframe = new JFrame("Scene block resolver");
            this._dframe.setContentPane(this._dpanel);
            this._dframe.pack();
            this._dframe.setVisible(true);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._dpanel != null) {
            this._dframe.dispose();
            this._dpanel = null;
            this._dframe = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.isResponsive()) {
            return;
        }
        if (e.getButton() == 1) {
            if (this._hobject instanceof Sprite) {
                this.handleSpritePressed((Sprite)this._hobject, e.getX(), e.getY());
                return;
            }
            if (this._hobject instanceof SceneObject) {
                this.handleObjectPressed((SceneObject)this._hobject, e.getX(), e.getY());
                return;
            }
        }
        this.handleMousePressed(this._hobject, e);
    }

    public void pressObject(SceneObject scobj) {
        int px = scobj.bounds.x + scobj.bounds.width / 2;
        int py = scobj.bounds.y + scobj.bounds.height / 2;
        this.handleObjectPressed(scobj, px, py);
    }

    protected void handleSpritePressed(Sprite sprite, int mx, int my) {
    }

    protected void handleObjectPressed(final SceneObject scobj, int mx, int my) {
        String action = scobj.info.action;
        final ObjectActionHandler handler = ObjectActionHandler.lookup(action);
        if (handler == null) {
            this.fireObjectAction(null, scobj, new SceneObjectActionEvent((Object)this, 0, action, 0, scobj));
            return;
        }
        if (!handler.actionAllowed(action)) {
            return;
        }
        RadialMenu menu = handler.handlePressed(scobj);
        if (menu == null) {
            this.fireObjectAction(handler, scobj, new SceneObjectActionEvent((Object)this, 0, action, 0, scobj));
            return;
        }
        Rectangle mbounds = this.getRadialMenuBounds(scobj);
        this._activeMenu = menu;
        this._activeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e instanceof CommandEvent) {
                    MisoScenePanel.this.fireObjectAction(handler, scobj, e);
                } else {
                    SceneObjectActionEvent event = new SceneObjectActionEvent(e.getSource(), e.getID(), e.getActionCommand(), e.getModifiers(), scobj);
                    MisoScenePanel.this.fireObjectAction(handler, scobj, event);
                }
            }
        });
        this._activeMenu.activate((RadialMenu.Host)this, mbounds, (Object)scobj);
    }

    protected Rectangle getRadialMenuBounds(SceneObject scobj) {
        Rectangle mbounds = new Rectangle(scobj.bounds);
        Dimension radbox = this.getObjectRadialSize();
        if (mbounds.width != radbox.width) {
            mbounds.x += (mbounds.width - radbox.width) / 2;
            mbounds.width = radbox.width;
        }
        if (mbounds.height != radbox.height) {
            mbounds.y += (mbounds.height - radbox.height) / 2;
            mbounds.height = radbox.height;
        }
        return mbounds;
    }

    protected Dimension getObjectRadialSize() {
        return DEF_RADIAL_RECT;
    }

    protected void fireObjectAction(ObjectActionHandler handler, SceneObject scobj, ActionEvent event) {
        if (handler == null) {
            Controller.postAction((ActionEvent)event);
        } else {
            handler.handleAction(scobj, event);
        }
    }

    protected boolean handleMousePressed(Object hobject, MouseEvent event) {
        return false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this._hcoords.setLocation(-1, -1);
        this.changeHoverObject(null);
        this._remgr.invalidateRegion(this._vbounds);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.updateTileCoords(x, y, this._hcoords);
        if (!this.isResponsive()) {
            return;
        }
        Object hobject = this.computeOverHover(x, y);
        if (hobject == null) {
            this._spritemgr.getHitSprites(this._hitSprites, x, y);
            int hslen = this._hitSprites.size();
            for (int ii = 0; ii < hslen; ++ii) {
                Sprite sprite = this._hitSprites.get(ii);
                this.appendDirtySprite(this._hitList, sprite);
            }
            this.getHitObjects(this._hitList, x, y);
            this._hitList.sort();
            int icount = this._hitList.size();
            if (icount > 0) {
                DirtyItemList.DirtyItem item = this._hitList.get(icount - 1);
                hobject = item.obj;
            }
            this._hitList.clear();
            this._hitSprites.clear();
        }
        if (hobject == null) {
            hobject = this.computeUnderHover(x, y);
        }
        this.changeHoverObject(hobject);
    }

    protected Object computeOverHover(int mx, int my) {
        return null;
    }

    protected Object computeUnderHover(int mx, int my) {
        return null;
    }

    @Override
    public boolean canTraverse(Object traverser, int tx, int ty) {
        SceneBlock block = this.getBlock(tx, ty);
        return block == null ? this.canTraverseUnresolved(traverser, tx, ty) : block.canTraverse(traverser, tx, ty);
    }

    protected boolean canTraverseUnresolved(Object traverser, int tx, int ty) {
        return false;
    }

    @Override
    public Rectangle getViewBounds() {
        return this._vbounds;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public void repaintRect(int x, int y, int width, int height) {
        this.repaint(x -= this._vbounds.x, y -= this._vbounds.y, width, height);
    }

    public void menuDeactivated(RadialMenu menu) {
        this._activeMenu = null;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width != this._rsize.width || height != this._rsize.height) {
            int dx = (this._rsize.width - width) / 2;
            int dy = (this._rsize.height - height) / 2;
            this.setViewLocation(this._nx + dx, this._ny + dy);
            this._rsize.setSize(width, height);
            this._ulpos = null;
        }
    }

    @Override
    protected void viewLocationDidChange(int dx, int dy) {
        super.viewLocationDidChange(dx, dy);
        MisoUtil.screenToTile(this._metrics, this._vbounds.x, this._vbounds.y, this._tcoords);
        if (this._ulpos == null || !this._tcoords.equals(this._ulpos)) {
            boolean mightDelayPaint = false;
            if (this._ulpos == null) {
                this._ulpos = new Point();
                mightDelayPaint = true;
            }
            this._ulpos.setLocation(this._tcoords);
            if (this.rethink() > 0) {
                this._delayRepaint = mightDelayPaint;
                if (this._delayRepaint) {
                    this.setVisible(false);
                }
                Log.log.info((Object)"Got new pending blocks", new Object[]{"need", this._visiBlocks.size(), "of", this._pendingBlocks, "view", StringUtil.toString((Object)this._vbounds), "delay", this._delayRepaint});
            }
        }
    }

    protected TileSet.Colorizer getColorizer(ObjectInfo oinfo) {
        return null;
    }

    protected void appendDirtySprite(DirtyItemList list, Sprite sprite) {
        MisoUtil.screenToTile(this._metrics, sprite.getX(), sprite.getY(), this._tcoords);
        list.appendDirtySprite(sprite, this._tcoords.x, this._tcoords.y);
    }

    protected TileManager getTileManager() {
        return this._ctx.getTileManager();
    }

    protected int rethink() {
        this.computeInfluentialBounds();
        if (this._model == null) {
            return 0;
        }
        this._applicator.applyToTiles(this._ibounds, this._rethinkOp);
        Point key = new Point();
        Iterator<SceneBlock> iter = this._blocks.values().iterator();
        while (iter.hasNext()) {
            SceneBlock block = iter.next();
            key.x = block.getBounds().x;
            key.y = block.getBounds().y;
            if (this._rethinkOp.blocks.contains(key)) continue;
            Log.log.debug((Object)("Flushing block " + block + "."), new Object[0]);
            if (this._dpanel != null) {
                this._dpanel.blockCleared(block);
            }
            iter.remove();
        }
        for (Point origin : this._rethinkOp.blocks) {
            int by;
            int bx = MathUtil.floorDiv(origin.x, this._metrics.blockwid);
            int bkey = MisoScenePanel.compose(bx, by = MathUtil.floorDiv(origin.y, this._metrics.blockhei));
            if (this._blocks.containsKey(bkey)) continue;
            SceneBlock block = new SceneBlock(this, origin.x, origin.y, this._metrics.blockwid, this._metrics.blockhei);
            boolean visible = block.getFootprint().getBounds().intersects(this._vibounds);
            block.setVisiBlock(visible);
            this._blocks.put(bkey, block);
            ++this._pendingBlocks;
            if (visible) {
                this._visiBlocks.add(block);
            }
            this._resolver.resolveBlock(block, visible);
            if (this._dpanel == null) continue;
            this._dpanel.queuedBlock(block);
        }
        this._rethinkOp.blocks.clear();
        this.recomputeVisible();
        Log.log.debug((Object)("Rethunk [pending=" + this._pendingBlocks + ", visible=" + this._visiBlocks.size() + "]."), new Object[0]);
        return this._visiBlocks.size();
    }

    protected void computeInfluentialBounds() {
        MisoScenePanel.computeInfluentialBounds(this._vbounds, this._ibounds, this._vibounds);
    }

    public static void computeInfluentialBounds(Rectangle visibleBounds, Rectangle influentualBounds, Rectangle visibleBlockBounds) {
        int infborx = 3 * visibleBounds.width / 4;
        int infbory = visibleBounds.height / 2;
        influentualBounds.setBounds(visibleBounds.x - infborx, visibleBounds.y - infbory, visibleBounds.width + 2 * infborx, visibleBounds.height + 3 * infbory);
        visibleBlockBounds.setBounds(visibleBounds.x - visibleBounds.width / 4, visibleBounds.y, visibleBounds.width + visibleBounds.width / 2, visibleBounds.height + infbory);
    }

    protected Rectangle getInfluentialBounds() {
        return this._ibounds;
    }

    protected void blockResolving(SceneBlock block) {
        if (this._dpanel != null) {
            this._dpanel.resolvingBlock(block);
        }
    }

    protected void blockAbandoned(SceneBlock block) {
        if (this._dpanel != null) {
            this._dpanel.blockCleared(block);
        }
        this.blockFinished(block);
    }

    protected void blockResolved(SceneBlock block) {
        if (this._dpanel != null) {
            this._dpanel.resolvedBlock(block);
        }
        Rectangle sbounds = block.getScreenBounds();
        if (!this._delayRepaint && sbounds != null && sbounds.intersects(this._vbounds) && this._pendingBlocks > 1) {
            this.recomputeVisible();
            this._remgr.invalidateRegion(sbounds);
        }
        this.blockFinished(block);
    }

    protected void blockFinished(SceneBlock block) {
        --this._pendingBlocks;
        if (this._visiBlocks.remove(block) && this._visiBlocks.size() == 0) {
            this.allBlocksFinished();
        }
    }

    protected void allBlocksFinished() {
        this.recomputeVisible();
        Log.log.info((Object)"Restoring repaint... ", new Object[]{"left", this._pendingBlocks, "view", StringUtil.toString((Object)this._vbounds)});
        this._delayRepaint = false;
        this.setVisible(true);
        this._remgr.invalidateRegion(this._vbounds);
    }

    protected void warnVisible(SceneBlock block, Rectangle sbounds) {
        Log.log.warning((Object)("Block visible during resolution " + block + " sbounds:" + StringUtil.toString((Object)sbounds) + " vbounds:" + StringUtil.toString((Object)this._vbounds) + "."), new Object[0]);
    }

    protected void recomputeVisible() {
        this._vizobjs.clear();
        Rectangle vbounds = new Rectangle(this._vbounds.x - this._metrics.tilewid, this._vbounds.y - this._metrics.tilehei, this._vbounds.width + 2 * this._metrics.tilewid, this._vbounds.height + 2 * this._metrics.tilehei);
        for (SceneBlock block : this._blocks.values()) {
            SceneObject[] objs;
            if (!block.isResolved()) continue;
            block.update(this._blocks);
            for (SceneObject obj : objs = block.getObjects()) {
                if (obj.bounds == null || !vbounds.intersects(obj.bounds)) continue;
                this._vizobjs.add(obj);
            }
        }
        this.computeIndicators();
    }

    protected static int compose(int x, int y) {
        return x << 16 | y & 0xFFFF;
    }

    public void computeIndicators() {
        HashMap _unupdated = Maps.newHashMap(this._indicators);
        int nn = this._vizobjs.size();
        for (int ii = 0; ii < nn; ++ii) {
            String tiptext;
            ObjectActionHandler oah;
            SceneObject scobj = this._vizobjs.get(ii);
            String action = scobj.info.action;
            if (StringUtil.isBlank((String)action) || (oah = ObjectActionHandler.lookup(action)) != null && !oah.isVisible(action) || (tiptext = this.getTipText(scobj, action)) == null) continue;
            Icon icon = this.getTipIcon(scobj, action);
            SceneObjectIndicator indic = (SceneObjectIndicator)_unupdated.remove(scobj);
            if (indic == null) {
                indic = oah != null ? oah.createIndicator(this, tiptext, icon) : new SceneObjectTip(tiptext, icon);
                this._indicators.put(scobj, indic);
            } else {
                indic.update(icon, tiptext);
            }
            this.dirtyIndicator(indic);
        }
        for (SceneObject toremove : _unupdated.keySet()) {
            SceneObjectIndicator indic = this._indicators.remove(toremove);
            indic.removed();
            this.dirtyIndicator(indic);
        }
        this._indicatorsLaidOut = false;
    }

    protected String getTipText(SceneObject scobj, String action) {
        ObjectActionHandler oah = ObjectActionHandler.lookup(action);
        return oah == null ? action : oah.getTipText(action);
    }

    protected Icon getTipIcon(SceneObject scobj, String action) {
        ObjectActionHandler oah = ObjectActionHandler.lookup(action);
        return oah == null ? null : oah.getTipIcon(action);
    }

    protected void dirtyIndicator(SceneObjectIndicator indic) {
        Rectangle r;
        if (indic != null && (r = indic.getBounds()) != null) {
            this._remgr.invalidateRegion(r);
        }
    }

    protected void changeHoverObject(Object newHover) {
        if (newHover == this._hobject) {
            return;
        }
        Object oldHover = this._hobject;
        this._hobject = newHover;
        this.hoverObjectChanged(oldHover, newHover);
    }

    protected void hoverObjectChanged(Object oldHover, Object newHover) {
        SceneObject newhov;
        SceneObject oldhov;
        if (oldHover instanceof SceneObject && (oldhov = (SceneObject)oldHover).setHovered(false)) {
            this._remgr.invalidateRegion(oldhov.bounds);
        }
        if (newHover instanceof SceneObject && (newhov = (SceneObject)newHover).setHovered(true)) {
            this._remgr.invalidateRegion(newhov.bounds);
        }
        this.dirtyIndicator(this._indicators.get(oldHover));
        this.dirtyIndicator(this._indicators.get(newHover));
    }

    protected void getHitObjects(DirtyItemList list, int x, int y) {
        for (SceneObject scobj : this._vizobjs) {
            Rectangle pbounds = scobj.bounds;
            if (!pbounds.contains(x, y) || this.skipHitObject(scobj) || !scobj.tile.hitTest(x - pbounds.x, y - pbounds.y)) continue;
            list.appendDirtyObject(scobj);
        }
    }

    protected boolean skipHitObject(SceneObject scobj) {
        return StringUtil.isBlank((String)scobj.info.action);
    }

    protected boolean updateTileCoords(int sx, int sy, Point tpos) {
        Point npos = MisoUtil.screenToTile(this._metrics, sx, sy, new Point());
        if (!tpos.equals(npos)) {
            tpos.setLocation(npos.x, npos.y);
            return true;
        }
        return false;
    }

    @Override
    public void paint(Graphics g) {
        if (this._delayRepaint) {
            return;
        }
        super.paint(g);
    }

    @Override
    protected void paintInFront(Graphics2D gfx, Rectangle dirty) {
        super.paintInFront(gfx, dirty);
        if (this._activeMenu != null) {
            this._activeMenu.render(gfx);
        }
    }

    @Override
    protected void paintBetween(Graphics2D gfx, Rectangle dirty) {
        this.paintTiles(gfx, dirty);
        this.paintBaseDecorations(gfx, dirty);
        this.paintDirtyItems(gfx, dirty);
        if (_pathsDebug.getValue()) {
            this._spritemgr.renderSpritePaths(gfx);
        }
        this.paintExtras(gfx, dirty);
    }

    @Override
    protected void paintBits(Graphics2D gfx, int layer, Rectangle dirty) {
        this._animmgr.paint(gfx, layer, dirty);
    }

    protected void paintBaseDecorations(Graphics2D gfx, Rectangle clip) {
    }

    protected void paintDirtyItems(Graphics2D gfx, Rectangle clip) {
        this._dirtySprites.clear();
        this._spritemgr.getIntersectingSprites(this._dirtySprites, clip);
        int size = this._dirtySprites.size();
        for (int ii = 0; ii < size; ++ii) {
            Sprite sprite = this._dirtySprites.get(ii);
            Rectangle bounds = sprite.getBounds();
            if (!bounds.intersects(clip)) continue;
            this.appendDirtySprite(this._dirtyItems, sprite);
        }
        for (SceneObject scobj : this._vizobjs) {
            if (!scobj.bounds.intersects(clip)) continue;
            this._dirtyItems.appendDirtyObject(scobj);
        }
        this._dirtyItems.sort();
        this._dirtyItems.paintAndClear(gfx);
    }

    protected void paintExtras(Graphics2D gfx, Rectangle clip) {
        if (this.isResponsive()) {
            this.paintIndicators(gfx, clip);
        }
    }

    protected void paintIndicators(Graphics2D gfx, Rectangle clip) {
        if (!this._indicatorsLaidOut) {
            for (Map.Entry<SceneObject, SceneObjectIndicator> entry : this._indicators.entrySet()) {
                SceneObjectIndicator indic = entry.getValue();
                if (indic.isLaidOut()) continue;
                indic.layout(gfx, entry.getKey(), this._vbounds);
                this.dirtyIndicator(indic);
            }
            this._indicatorsLaidOut = true;
        }
        if (this.checkShowFlag(1)) {
            for (SceneObjectIndicator indic : this._indicators.values()) {
                this.paintIndicator(gfx, clip, indic);
            }
        } else {
            SceneObjectIndicator indic = this._indicators.get(this._hobject);
            if (indic != null) {
                this.paintIndicator(gfx, clip, indic);
            }
        }
    }

    protected void paintIndicator(Graphics2D gfx, Rectangle clip, SceneObjectIndicator tip) {
        if (clip.intersects(tip.getBounds())) {
            tip.paint(gfx);
        }
    }

    protected void paintTiles(Graphics2D gfx, Rectangle clip) {
        this._paintOp.setGraphics(gfx);
        this._applicator.applyToTiles(clip, this._paintOp);
        this._paintOp.setGraphics(null);
    }

    protected void fillTile(Graphics2D gfx, int tx, int ty, Color color) {
        Composite ocomp = gfx.getComposite();
        gfx.setComposite(ALPHA_FILL_TILE);
        Polygon poly = MisoUtil.getTilePolygon(this._metrics, tx, ty);
        gfx.setColor(color);
        gfx.fill(poly);
        gfx.setComposite(ocomp);
    }

    protected BaseTile getBaseTile(int tx, int ty) {
        SceneBlock block = this.getBlock(tx, ty);
        return block == null ? null : block.getBaseTile(tx, ty);
    }

    protected BaseTile getFringeTile(int tx, int ty) {
        SceneBlock block = this.getBlock(tx, ty);
        return block == null ? null : block.getFringeTile(tx, ty);
    }

    protected BaseTile computeFringeTile(int tx, int ty) {
        return this._ctx.getTileManager().getAutoFringer().getFringeTile(this._model, tx, ty, this._fringes, this._masks);
    }

    protected boolean isResponsive() {
        return true;
    }

    protected class PaintTileOp
    implements TileOp {
        protected Graphics2D _gfx;
        protected FontMetrics _fm;
        protected int _thw;
        protected int _thh;
        protected int _fhei;
        protected Font _font = new Font("Arial", 0, 7);

        protected PaintTileOp() {
        }

        public void setGraphics(Graphics2D gfx) {
            this._gfx = gfx;
            this._thw = 0;
            this._thh = 0;
            this._fhei = 0;
            this._fm = null;
            if (gfx != null && _coordsDebug.getValue()) {
                this._fm = gfx.getFontMetrics(this._font);
                this._fhei = this._fm.getAscent();
                this._thw = MisoScenePanel.this._metrics.tilehwid;
                this._thh = MisoScenePanel.this._metrics.tilehhei;
                gfx.setFont(this._font);
            }
        }

        public void apply(int tx, int ty, Rectangle tbounds) {
            try {
                boolean passable = true;
                BaseTile tile = MisoScenePanel.this.getBaseTile(tx, ty);
                if (tile != null) {
                    tile.paint(this._gfx, tbounds.x, tbounds.y);
                    passable = tile.isPassable();
                } else {
                    Polygon poly = MisoUtil.getTilePolygon(MisoScenePanel.this._metrics, tx, ty);
                    this._gfx.setColor(Color.black);
                    this._gfx.fill(poly);
                }
                tile = MisoScenePanel.this.getFringeTile(tx, ty);
                if (tile != null) {
                    tile.paint(this._gfx, tbounds.x, tbounds.y);
                    boolean bl = passable = passable && tile.isPassable();
                }
                if (_traverseDebug.getValue()) {
                    if (!passable) {
                        MisoScenePanel.this.fillTile(this._gfx, tx, ty, Color.yellow);
                    } else if (!MisoScenePanel.this.canTraverse(null, tx, ty)) {
                        MisoScenePanel.this.fillTile(this._gfx, tx, ty, Color.green);
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.log.warning((Object)"Whoops, booched it", new Object[]{"tx", tx, "ty", ty, "tb.x", tbounds.x});
                e.printStackTrace(System.err);
            }
            if (_coordsDebug.getValue()) {
                int by;
                int bx = MathUtil.floorDiv(tx, MisoScenePanel.this._metrics.blockwid);
                if ((bx % 2 ^ (by = MathUtil.floorDiv(ty, MisoScenePanel.this._metrics.blockhei)) % 2) == 0) {
                    this._gfx.setColor(Color.white);
                } else {
                    this._gfx.setColor(Color.yellow);
                }
                int sx = tbounds.x;
                int sy = tbounds.y;
                String str = String.valueOf(tx);
                int xpos = sx + this._thw - this._fm.stringWidth(str) / 2;
                this._gfx.drawString(str, xpos, sy + this._thh);
                str = String.valueOf(ty);
                xpos = sx + this._thw - this._fm.stringWidth(str) / 2;
                this._gfx.drawString(str, xpos, sy + this._thh + this._fhei);
                this._gfx.draw(MisoUtil.getTilePolygon(MisoScenePanel.this._metrics, tx, ty));
            }
        }
    }
}

