/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.util;

import com.google.common.collect.Lists;
import com.samskivert.util.HashIntMap;
import com.threerings.media.util.MathUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AStarPathUtil {
    public static final int ADJACENT_COST = 10;
    public static final int DIAGONAL_COST = (int)Math.sqrt(200.0);
    protected static int _considered = 0;

    public static List<Point> getPath(TraversalPred tpred, Stepper stepper, Object trav, int longest, int ax, int ay, int bx, int by, boolean partial) {
        Info info = new Info(tpred, trav, longest, bx, by);
        Node s = info.getNode(ax, ay);
        s.g = 0;
        s.h = AStarPathUtil.getDistanceEstimate(ax, ay, bx, by);
        s.f = s.g + s.h;
        info.open.add(s);
        _considered = 1;
        float bestdist = Float.MAX_VALUE;
        Node bestpath = null;
        while (info.open.size() > 0) {
            float pathdist;
            Node n = info.open.first();
            info.open.remove(n);
            if (n.x == bx && n.y == by) {
                return AStarPathUtil.getNodePath(n);
            }
            if (partial && (pathdist = MathUtil.distance(n.x, n.y, bx, by)) < bestdist) {
                bestdist = pathdist;
                bestpath = n;
            }
            stepper.init(info, n);
            stepper.considerSteps(n.x, n.y);
            n.closed = true;
        }
        if (bestpath != null) {
            return AStarPathUtil.getNodePath(bestpath);
        }
        return null;
    }

    public static List<Point> getPath(TraversalPred tpred, Object trav, int longest, int ax, int ay, int bx, int by, boolean partial) {
        return AStarPathUtil.getPath(tpred, new Stepper(false), trav, longest, ax, ay, bx, by, partial);
    }

    public static int getConsidered() {
        return _considered;
    }

    protected static void considerStep(Info info, Node n, int x, int y, int cost) {
        if (!info.isStepValid(n.x, n.y, x, y)) {
            return;
        }
        int newg = n.g + cost;
        if (newg > info.maxcost) {
            return;
        }
        Node np = info.getNode(x, y);
        if ((np.closed || info.open.contains(np)) && np.g <= newg) {
            return;
        }
        info.open.remove(np);
        np.parent = n;
        np.g = newg;
        np.h = AStarPathUtil.getDistanceEstimate(np.x, np.y, info.destx, info.desty);
        np.f = np.g + np.h;
        np.closed = false;
        info.open.add(np);
        ++_considered;
    }

    protected static List<Point> getNodePath(Node n) {
        Node cur = n;
        ArrayList path = Lists.newArrayList();
        while (cur != null) {
            path.add(0, new Point(cur.x, cur.y));
            cur = cur.parent;
        }
        return path;
    }

    protected static int getDistanceEstimate(int ax, int ay, int bx, int by) {
        int xsq = bx - ax;
        int ysq = by - ay;
        return (int)(10.0 * Math.sqrt(xsq * xsq + ysq * ysq));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node
    implements Comparable<Node> {
        public int x;
        public int y;
        public int g;
        public int h;
        public int f;
        public Node parent;
        public int id;
        public boolean closed;
        protected static int _nextid = 0;

        public Node(int x, int y) {
            this.x = x;
            this.y = y;
            this.id = _nextid++;
        }

        @Override
        public int compareTo(Node o) {
            int bf = o.f;
            if (this.f == bf) {
                return this == o ? 0 : this.id - o.id;
            }
            return this.f - bf;
        }
    }

    protected static class Info {
        public TraversalPred tpred;
        public int tilewid;
        public int tilehei;
        public Object trav;
        public SortedSet<Node> open;
        public int destx;
        public int desty;
        public int maxcost;
        protected HashIntMap<Node> _nodes = new HashIntMap();

        public Info(TraversalPred tpred, Object trav, int longest, int destx, int desty) {
            this.tpred = tpred;
            this.trav = trav;
            this.destx = destx;
            this.desty = desty;
            this.maxcost = longest * 10;
            this.open = new TreeSet<Node>();
        }

        protected boolean isStepValid(int sx, int sy, int dx, int dy) {
            if (this.tpred instanceof ExtendedTraversalPred ? !((ExtendedTraversalPred)this.tpred).canTraverse(this.trav, sx, sy, dx, dy) : !this.isTraversable(dx, dy)) {
                return false;
            }
            if (Math.abs(dx - sx) == 1 && Math.abs(dy - sy) == 1) {
                return this.isTraversable(dx, sy) && this.isTraversable(sx, dy);
            }
            return true;
        }

        protected boolean isTraversable(int x, int y) {
            return this.tpred.canTraverse(this.trav, x, y);
        }

        public Node getNode(int x, int y) {
            int key = x << 16 | y & 0xFFFF;
            Node node = (Node)this._nodes.get(key);
            if (node == null) {
                node = new Node(x, y);
                this._nodes.put(key, (Object)node);
            }
            return node;
        }
    }

    public static class Stepper {
        protected boolean _considerDiagonals;
        protected Info _info;
        protected Node _node;

        public Stepper() {
            this(false);
        }

        public Stepper(boolean considerDiagonals) {
            this._considerDiagonals = considerDiagonals;
        }

        public void init(Info info, Node n) {
            this._info = info;
            this._node = n;
        }

        public void considerSteps(int x, int y) {
            this.considerStep(x, y - 1, 10);
            this.considerStep(x, y + 1, 10);
            this.considerStep(x - 1, y, 10);
            this.considerStep(x + 1, y, 10);
            if (this._considerDiagonals) {
                this.considerStep(x - 1, y - 1, DIAGONAL_COST);
                this.considerStep(x + 1, y - 1, DIAGONAL_COST);
                this.considerStep(x - 1, y + 1, DIAGONAL_COST);
                this.considerStep(x + 1, y + 1, DIAGONAL_COST);
            }
        }

        protected void considerStep(int x, int y, int cost) {
            AStarPathUtil.considerStep(this._info, this._node, x, y, cost);
        }
    }

    public static interface ExtendedTraversalPred
    extends TraversalPred {
        public boolean canTraverse(Object var1, int var2, int var3, int var4, int var5);
    }

    public static interface TraversalPred {
        public boolean canTraverse(Object var1, int var2, int var3);
    }
}

