/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.chat;

import com.samskivert.swing.Label;
import com.samskivert.swing.util.SwingUtil;
import com.threerings.NenyaLog;
import com.threerings.chat.SubtitleChatOverlay;
import com.threerings.media.animation.Animation;
import com.threerings.media.image.ColorUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import javax.swing.Icon;

public class ChatGlyph
extends Animation {
    public int histIndex;
    protected SubtitleChatOverlay _owner;
    protected int _type;
    protected Shape _shape;
    protected Icon _icon;
    protected Point _ipos;
    protected Label _label;
    protected Point _lpos;
    protected float _alpha = 0.9f;
    protected boolean _dim = false;
    protected static final long ANIM_TIME = 800L;
    protected long _lifetime;
    protected long _bornStamp;
    protected Color _outline;
    protected Color _background;
    protected static final float ALPHA = 0.9f;

    public ChatGlyph(SubtitleChatOverlay owner, int type, long lifetime, Rectangle bounds, Shape shape, Icon icon, Point iconpos, Label label, Point labelpos, Color outline) {
        super(bounds);
        this.jiggleBounds();
        this._owner = owner;
        this._shape = shape;
        this._type = type;
        this._icon = icon;
        this._ipos = iconpos;
        this._label = label;
        this._lpos = labelpos;
        this._lifetime = lifetime;
        this._outline = outline;
        this._background = Color.BLACK.equals(this._outline) ? Color.WHITE : ColorUtil.blend(Color.WHITE, this._outline, 0.8f);
    }

    public void setDim(boolean dim) {
        if (this._dim != dim) {
            this._dim = dim;
            this.invalidate();
        }
    }

    public void render(Graphics2D gfx) {
        Object oalias = SwingUtil.activateAntiAliasing((Graphics2D)gfx);
        gfx.setColor(this.getBackground());
        gfx.fill(this._shape);
        gfx.setColor(this._outline);
        gfx.draw(this._shape);
        SwingUtil.restoreAntiAliasing((Graphics2D)gfx, (Object)oalias);
        if (this._icon != null) {
            this._icon.paintIcon(this._owner.getTarget(), gfx, this._ipos.x, this._ipos.y);
        }
        gfx.setColor(Color.BLACK);
        this._label.render(gfx, (float)this._lpos.x, (float)this._lpos.y);
    }

    public int getType() {
        return this._type;
    }

    public Shape getShape() {
        return this._shape;
    }

    public void setLocation(int x, int y) {
        int dx = x - this._bounds.x;
        int dy = y - this._bounds.y;
        super.setLocation(x, y);
        if (dx != 0 || dy != 0) {
            if (this._ipos != null) {
                this._ipos.translate(dx, dy);
            }
            this._lpos.translate(dx, dy);
            if (this._shape instanceof Area) {
                ((Area)this._shape).transform(AffineTransform.getTranslateInstance(dx, dy));
            } else if (this._shape instanceof Polygon) {
                ((Polygon)this._shape).translate(dx, dy);
            } else {
                NenyaLog.log.warning((Object)"Unable to translate shape", new Object[]{"glyph", this, "shape", this._shape + "]!"});
            }
        }
    }

    public void viewDidScroll(int dx, int dy) {
        this.translate(dx, dy);
    }

    public void translate(int dx, int dy) {
        this.setLocation(this._bounds.x + dx, this._bounds.y + dy);
    }

    public void tick(long tickStamp) {
        long deathTime;
        if (this._bornStamp == 0L) {
            this._bornStamp = tickStamp;
            this.invalidate();
        }
        if (tickStamp < (deathTime = this._bornStamp + this._lifetime)) {
            return;
        }
        long msecs = tickStamp - deathTime;
        if (msecs >= 800L) {
            this._alpha = 0.0f;
            this._finished = true;
            this._owner.glyphExpired(this);
        } else {
            this._alpha = 0.9f * (float)(800L - msecs) / 800.0f;
        }
        this.invalidate();
    }

    public void fastForward(long timeDelta) {
        if (this._bornStamp > 0L) {
            this._bornStamp += timeDelta;
        }
    }

    public void paint(Graphics2D gfx) {
        float alpha;
        float f = alpha = this._dim ? this._alpha / 3.0f : this._alpha;
        if (alpha == 0.0f) {
            return;
        }
        if (alpha != 1.0f) {
            Composite ocomp = gfx.getComposite();
            gfx.setComposite(AlphaComposite.getInstance(3, alpha));
            this.render(gfx);
            gfx.setComposite(ocomp);
        } else {
            this.render(gfx);
        }
    }

    protected Color getBackground() {
        return this._background;
    }

    protected void jiggleBounds() {
        this._bounds.setSize(this._bounds.width + 1, this._bounds.height + 1);
    }
}

