/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.util;

import com.samskivert.util.StringUtil;
import com.threerings.media.util.Path;
import com.threerings.media.util.Pathable;
import com.threerings.media.util.TimedPath;
import com.threerings.util.DirectionUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;

public class ArcPath
extends TimedPath {
    public static final int NORMAL = 0;
    public static final int FINE = 1;
    public static final int NONE = 2;
    protected Point _center;
    protected double _xradius;
    protected double _yradius;
    protected double _sangle;
    protected double _delta;
    protected int _orient;
    protected int _orientOffset = 0;
    protected Point _tpos = new Point();

    public ArcPath(Point start, double xradius, double yradius, double sangle, double delta, long duration, int orient) {
        super(duration);
        this._xradius = xradius;
        this._yradius = yradius;
        this._sangle = sangle;
        this._delta = delta;
        this._orient = orient;
        this._center = new Point((int)((long)start.x - Math.round(Math.cos(sangle) * xradius)), (int)((long)start.y - Math.round(Math.sin(sangle) * yradius)));
    }

    public Path getTranslatedInstance(int x, int y) {
        int startx = (int)((long)this._center.x + Math.round(Math.cos(this._sangle) * this._xradius));
        int starty = (int)((long)this._center.y + Math.round(Math.sin(this._sangle) * this._yradius));
        return new ArcPath(new Point(startx + x, starty + y), this._xradius, this._yradius, this._sangle, this._delta, this._duration, this._orient);
    }

    public void setOrientOffset(int offset) {
        this._orientOffset = offset;
    }

    public Point getEndPos() {
        return new Point((int)((long)this._center.x + Math.round(Math.cos(this._sangle + this._delta) * this._xradius)), (int)((long)this._center.y + Math.round(Math.sin(this._sangle + this._delta) * this._yradius)));
    }

    @Override
    public boolean tick(Pathable pable, long timestamp) {
        double angle;
        boolean modified = false;
        if (timestamp >= this._startStamp + this._duration) {
            angle = this._sangle + this._delta;
        } else {
            long elapsed = timestamp - this._startStamp;
            angle = this._sangle + this._delta * (double)elapsed / (double)this._duration;
        }
        ArcPath.computePosition(this._center, this._xradius, this._yradius, angle, this._tpos);
        if (this._orient != 2) {
            int orient;
            double theta = angle + (this._delta > 0.0 ? 1.5707963267948966 : -1.5707963267948966);
            switch (this._orient) {
                default: {
                    orient = DirectionUtil.getDirection(theta);
                    orient = DirectionUtil.rotateCW(orient, 2 * this._orientOffset);
                    break;
                }
                case 1: {
                    orient = DirectionUtil.getFineDirection(theta);
                    orient = DirectionUtil.rotateCW(orient, this._orientOffset);
                }
            }
            if (pable.getOrientation() != orient) {
                pable.setOrientation(orient);
                modified = true;
            }
        }
        if (pable.getX() != this._tpos.x || pable.getY() != this._tpos.y) {
            pable.setLocation(this._tpos.x, this._tpos.y);
            modified = true;
        }
        if (angle == this._sangle + this._delta) {
            pable.pathCompleted(timestamp);
        }
        return modified;
    }

    @Override
    public void paint(Graphics2D gfx) {
        int x = (int)((double)this._center.x - this._xradius);
        int y = (int)((double)this._center.y - this._yradius);
        int width = (int)(2.0 * this._xradius);
        int height = (int)(2.0 * this._yradius);
        int sangle = (int)Math.round(180.0 * this._sangle / Math.PI);
        int delta = (int)Math.round(180.0 * this._delta / Math.PI);
        gfx.setColor(Color.blue);
        gfx.drawRect(x, y, width - 1, height - 1);
        gfx.setColor(Color.yellow);
        gfx.drawArc(x, y, width - 1, height - 1, 0, 360);
        gfx.setColor(Color.red);
        gfx.drawArc(x, y, width - 1, height - 1, 360 - sangle, -delta);
    }

    @Override
    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", center=").append(StringUtil.toString((Object)this._center));
        buf.append(", sangle=").append(this._sangle);
        buf.append(", delta=").append(this._delta);
        buf.append(", radii=").append(this._xradius).append("/").append(this._yradius);
    }

    public static void computePosition(Point center, double xradius, double yradius, double angle, Point pos) {
        pos.x = (int)Math.round((double)center.x + xradius * Math.cos(angle));
        pos.y = (int)Math.round((double)center.y + yradius * Math.sin(angle));
    }
}

