/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.resource;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.io.ByteArrayOutInputStream;
import com.samskivert.util.StringUtil;
import com.threerings.geom.GeomUtil;
import com.threerings.media.image.ColorPository;
import com.threerings.media.image.Colorization;
import com.threerings.media.image.ImageUtil;
import com.threerings.resource.Log;
import com.threerings.resource.ResourceHandler;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class SubImageResourceHandler
extends ResourceHandler {
    protected InputStream getStream(String bundle, String path, String query) throws IOException {
        if (!path.endsWith(".png")) {
            Log.log.warning((Object)"Requested sub-tile of non-PNG resource", new Object[]{"bundle", bundle, "path", path, "dims", query});
            return this._rmgr.getResource(bundle, path);
        }
        String[] bits = StringUtil.split((String)query, (String)"&");
        int width = -1;
        int height = -1;
        int tidx = -1;
        HashMap zations = null;
        try {
            for (String bit : bits) {
                if (bit.startsWith("width=")) {
                    width = Integer.parseInt(bit.substring(6));
                    continue;
                }
                if (bit.startsWith("height=")) {
                    height = Integer.parseInt(bit.substring(7));
                    continue;
                }
                if (bit.startsWith("tile=")) {
                    tidx = Integer.parseInt(bit.substring(5));
                    continue;
                }
                if (!bit.startsWith("zation=")) continue;
                String[] zation = bit.substring(7).split(":");
                if (zations == null) {
                    zations = Maps.newHashMap();
                }
                zations.put(zation[0], zation[1]);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        if (width <= 0 || height <= 0 || tidx < 0) {
            Log.log.warning((Object)"Bogus sub-image dimensions", new Object[]{"bundle", bundle, "path", path, "dims", query});
            throw new FileNotFoundException(path);
        }
        BufferedImage src = StringUtil.isBlank((String)bundle) ? this._rmgr.getImageResource(path) : this._rmgr.getImageResource(bundle, path);
        Rectangle trect = GeomUtil.getTile(src.getWidth(), src.getHeight(), width, height, tidx);
        BufferedImage tile = src.getSubimage(trect.x, trect.y, trect.width, trect.height);
        if (zations != null) {
            ColorPository pository = ColorPository.loadColorPository(this._rmgr);
            ArrayList colorizations = Lists.newArrayList();
            for (Map.Entry entry : zations.entrySet()) {
                String zClass = (String)entry.getKey();
                String zColor = (String)entry.getValue();
                Colorization zation = null;
                try {
                    zation = pository.getColorization(zClass, Integer.parseInt(zColor));
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (zation == null) {
                    zation = pository.getColorization(zClass, zColor);
                }
                if (zation == null) {
                    Log.log.warning((Object)"Couldn't figure out requested zation", new Object[]{"class", zClass, "color", zColor});
                    continue;
                }
                colorizations.add(zation);
            }
            tile = ImageUtil.recolorImage(tile, colorizations.toArray(new Colorization[colorizations.size()]));
        }
        ByteArrayOutInputStream data = new ByteArrayOutInputStream();
        ImageIO.write((RenderedImage)tile, "PNG", (OutputStream)data);
        return data.getInputStream();
    }
}

