/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.animation;

import com.threerings.media.animation.Animation;
import com.threerings.media.sprite.Sprite;
import com.threerings.media.sprite.SpriteManager;
import com.threerings.media.util.LinearTimeFunction;
import com.threerings.media.util.TimeFunction;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;

public class GleamAnimation
extends Animation {
    protected SpriteManager _spmgr;
    protected Sprite _sprite;
    protected Color _color;
    protected Image _offimg;
    protected boolean _fadeIn;
    protected TimeFunction _upfunc;
    protected TimeFunction _downfunc;
    protected int _upmillis;
    protected int _downmillis;
    protected int _maxAlpha = 750;
    protected int _minAlpha;
    protected int _alpha;
    protected long _lastUpdate;
    protected int _millisBetweenUpdates;

    public GleamAnimation(Sprite sprite, Color color, int upmillis, int downmillis, boolean fadeIn) {
        this(null, sprite, color, upmillis, downmillis, fadeIn);
    }

    public GleamAnimation(SpriteManager spmgr, Sprite sprite, Color color, int upmillis, int downmillis, boolean fadeIn) {
        super(new Rectangle(sprite.getBounds()));
        this._spmgr = spmgr;
        this._sprite = sprite;
        this._color = color;
        this._upmillis = upmillis;
        this._downmillis = downmillis;
        this._fadeIn = fadeIn;
    }

    @Override
    public void tick(long timestamp) {
        int alpha;
        if (timestamp - this._lastUpdate < (long)this._millisBetweenUpdates) {
            return;
        }
        this._lastUpdate = timestamp;
        if (this._upfunc != null) {
            alpha = this._upfunc.getValue(timestamp);
            if (alpha >= this._maxAlpha) {
                this._upfunc = null;
            }
        } else if (this._downfunc != null) {
            alpha = this._downfunc.getValue(timestamp);
            if (alpha <= this._minAlpha) {
                this._downfunc = null;
            }
        } else {
            this._finished = true;
            return;
        }
        if (!this._bounds.equals(this._sprite.getBounds())) {
            Rectangle obounds = new Rectangle(this._bounds);
            this._bounds.setBounds(this._sprite.getBounds());
            this.invalidateAfterChange(obounds);
        }
        if (this._alpha != alpha) {
            this._alpha = alpha;
            this.invalidate();
        }
    }

    @Override
    public void fastForward(long timeDelta) {
        if (this._upfunc != null) {
            this._upfunc.fastForward(timeDelta);
        } else if (this._downfunc != null) {
            this._downfunc.fastForward(timeDelta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D gfx) {
        if (this._offimg == null) {
            this._offimg = gfx.getDeviceConfiguration().createCompatibleImage(this._bounds.width, this._bounds.height, 3);
        }
        Graphics2D ogfx = (Graphics2D)this._offimg.getGraphics();
        try {
            ogfx.setColor(this._color);
            ogfx.fillRect(0, 0, this._bounds.width, this._bounds.height);
            ogfx.setComposite(AlphaComposite.DstAtop);
            ogfx.translate(-this._sprite.getX(), -this._sprite.getY());
            this._sprite.paint(ogfx);
        }
        finally {
            ogfx.dispose();
        }
        Composite ocomp = null;
        AlphaComposite ncomp = AlphaComposite.getInstance(3, (float)this._alpha / 1000.0f);
        if (this._fadeIn && this._upfunc != null) {
            ocomp = gfx.getComposite();
            gfx.setComposite(ncomp);
        }
        this._sprite.paint(gfx);
        if (ocomp == null) {
            ocomp = gfx.getComposite();
            gfx.setComposite(ncomp);
        }
        gfx.drawImage(this._offimg, this._sprite.getX(), this._sprite.getY(), null);
        gfx.setComposite(ocomp);
    }

    @Override
    protected void willStart(long tickStamp) {
        this._upfunc = new LinearTimeFunction(this._minAlpha, this._maxAlpha, this._upmillis);
        this._downfunc = new LinearTimeFunction(this._maxAlpha, this._minAlpha, this._downmillis);
        super.willStart(tickStamp);
        if (this._spmgr != null && this._spmgr.isManaged(this._sprite)) {
            this._spmgr.removeSprite(this._sprite);
        }
    }

    @Override
    protected void shutdown() {
        super.shutdown();
        if (this._spmgr != null && !this._spmgr.isManaged(this._sprite)) {
            this._spmgr.addSprite(this._sprite);
        }
    }
}

