/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.sound;

import com.samskivert.io.StreamUtil;
import com.samskivert.util.Config;
import com.samskivert.util.ConfigUtil;
import com.samskivert.util.LRUHashMap;
import com.threerings.media.Log;
import com.threerings.media.sound.JavaSoundPlayer;
import com.threerings.resource.ResourceManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SoundLoader {
    protected ResourceManager _rmgr;
    protected String _defaultClipBundle;
    protected String _defaultClipPath;
    protected LRUHashMap<String, Config> _configs = new LRUHashMap(5);

    public SoundLoader(ResourceManager rmgr, String defaultBundle, String defaultPath) {
        this._rmgr = rmgr;
        this._defaultClipBundle = defaultBundle;
        this._defaultClipPath = defaultPath;
    }

    public byte[][] load(String packagePath, String key) throws IOException {
        String[] paths = this.getPaths(packagePath, key);
        if (paths == null) {
            Log.log.warning((Object)"No such sound", new Object[]{"key", key});
            return null;
        }
        byte[][] data = new byte[paths.length][];
        String bundle = this.getBundle(packagePath);
        int ii = 0;
        while (ii < paths.length) {
            data[ii] = this.loadClipData(bundle, paths[ii]);
            ++ii;
        }
        return data;
    }

    public String[] getPaths(String packagePath, String key) {
        return this.getConfig(packagePath).getValue(key, null);
    }

    public String getBundle(String packagePath) {
        return this.getConfig(packagePath).getValue("bundle", null);
    }

    public InputStream getSound(String bundle, String path) throws IOException {
        InputStream rsrc;
        try {
            rsrc = this._rmgr.getResource(bundle, path);
        }
        catch (FileNotFoundException notFound) {
            try {
                rsrc = this._rmgr.getResource(path);
            }
            catch (FileNotFoundException notFoundAgain) {
                throw notFound;
            }
        }
        return rsrc;
    }

    public void shutdown() {
        this._configs.clear();
    }

    protected Config getConfig(String packagePath) {
        Config c = (Config)this._configs.get((Object)packagePath);
        if (c == null) {
            String propPath = String.valueOf(packagePath) + "sounds";
            Properties props = new Properties();
            try {
                props = ConfigUtil.loadInheritedProperties((String)(String.valueOf(propPath) + ".properties"), (ClassLoader)this.getClass().getClassLoader());
            }
            catch (IOException ioe) {
                Log.log.warning((Object)"Failed to load sound properties", new Object[]{"path", propPath, ioe});
            }
            c = new Config(propPath, props);
            this._configs.put((Object)packagePath, (Object)c);
        }
        return c;
    }

    protected byte[] loadClipData(String bundle, String path) throws IOException {
        InputStream clipin;
        block10: {
            clipin = null;
            try {
                clipin = this.getSound(bundle, path);
            }
            catch (FileNotFoundException fnfe) {
                if (JavaSoundPlayer._verbose.getValue()) {
                    Log.log.warning((Object)"Could not locate sound data", new Object[]{"bundle", bundle, "path", path});
                    if (this._defaultClipPath != null) {
                        try {
                            clipin = this._rmgr.getResource(this._defaultClipBundle, this._defaultClipPath);
                        }
                        catch (FileNotFoundException fnfe3) {
                            try {
                                clipin = this._rmgr.getResource(this._defaultClipPath);
                            }
                            catch (FileNotFoundException fnfe4) {
                                Log.log.warning((Object)"Additionally, the default fallback sound could not be located", new Object[]{"bundle", this._defaultClipBundle, "path", this._defaultClipPath});
                            }
                        }
                    } else {
                        Log.log.warning((Object)"No fallback default sound specified!", new Object[0]);
                    }
                }
                if (clipin != null) break block10;
                throw fnfe;
            }
        }
        return StreamUtil.toByteArray((InputStream)clipin);
    }
}

