/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.client;

import com.samskivert.swing.Label;
import com.samskivert.swing.LabelSausage;
import com.samskivert.util.ComparableArrayList;
import com.samskivert.util.StringUtil;
import com.threerings.miso.client.SceneObject;
import com.threerings.miso.client.SceneObjectIndicator;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.UIManager;

public class SceneObjectTip
extends LabelSausage
implements SceneObjectIndicator {
    public Rectangle bounds;
    protected static final Composite ALPHA = AlphaComposite.getInstance(3, 0.75f);
    protected static Color _background = UIManager.getColor("SceneObjectTip.background");
    protected static Color _foreground = UIManager.getColor("SceneObjectTip.foreground");
    protected static Font _font = UIManager.getFont("SceneObjectTip.font");
    protected static ComparableArrayList<LayoutReg> _layouts;
    protected static final int ICON_PAD = 4;
    protected static final int EXTRA_PAD = 2;

    static {
        if (_font == null) {
            _font = UIManager.getFont("Label.font");
        }
        _layouts = new ComparableArrayList();
        SceneObjectTip.registerTipLayout("", new DefaultLayout());
    }

    public SceneObjectTip(String text, Icon icon) {
        super(new Label(text, _foreground, _font), icon);
    }

    @Override
    public boolean isLaidOut() {
        return this._label.isLaidOut();
    }

    @Override
    public void layout(Graphics2D gfx, SceneObject tipFor, Rectangle boundary) {
        this.layout(gfx, 4, 2);
        this.bounds = new Rectangle(this._size);
        int ii = 0;
        int ll = _layouts.size();
        while (ii < ll) {
            String act;
            LayoutReg reg = (LayoutReg)_layouts.get(ii);
            String string = act = tipFor.info.action == null ? "" : tipFor.info.action;
            if (act.startsWith(reg.prefix)) {
                reg.layout.layout(gfx, boundary, tipFor, this);
                break;
            }
            ++ii;
        }
    }

    @Override
    public void paint(Graphics2D gfx) {
        this.paint(gfx, this.bounds.x, this.bounds.y, _background, null);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void removed() {
    }

    @Override
    public void update(Icon icon, String tiptext) {
        this._label.setText(tiptext);
        this._icon = icon;
    }

    public String toString() {
        return String.valueOf(this._label.getText()) + "[" + StringUtil.toString((Object)this.bounds) + "]";
    }

    public static void registerTipLayout(String prefix, TipLayout layout) {
        LayoutReg reg = new LayoutReg();
        reg.prefix = prefix;
        reg.layout = layout;
        _layouts.insertSorted((Comparable)reg);
    }

    protected void drawBase(Graphics2D gfx, int x, int y) {
        Composite ocomp = gfx.getComposite();
        gfx.setComposite(ALPHA);
        super.drawBase(gfx, x, y);
        gfx.setComposite(ocomp);
    }

    protected static class DefaultLayout
    implements TipLayout {
        protected DefaultLayout() {
        }

        @Override
        public void layout(Graphics2D gfx, Rectangle boundary, SceneObject tipFor, SceneObjectTip tip) {
            tip.bounds.setLocation(tipFor.bounds.x + (tipFor.bounds.width - tip.bounds.width) / 2, tipFor.bounds.y + (tipFor.bounds.height - tip.bounds.height) / 2);
        }
    }

    protected static class LayoutReg
    implements Comparable<LayoutReg> {
        public String prefix;
        public TipLayout layout;

        protected LayoutReg() {
        }

        @Override
        public int compareTo(LayoutReg or) {
            if (or.prefix.length() == this.prefix.length()) {
                return or.prefix.compareTo(this.prefix);
            }
            return or.prefix.length() - this.prefix.length();
        }
    }

    public static interface TipLayout {
        public void layout(Graphics2D var1, Rectangle var2, SceneObject var3, SceneObjectTip var4);
    }
}

