/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile.bundle;

import com.google.common.collect.Maps;
import com.samskivert.io.PersistenceException;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.IntMap;
import com.threerings.media.Log;
import com.threerings.media.image.ImageManager;
import com.threerings.media.tile.IMImageProvider;
import com.threerings.media.tile.NoSuchTileSetException;
import com.threerings.media.tile.TileSet;
import com.threerings.media.tile.TileSetRepository;
import com.threerings.media.tile.bundle.BundleUtil;
import com.threerings.media.tile.bundle.TileSetBundle;
import com.threerings.resource.ResourceBundle;
import com.threerings.resource.ResourceManager;
import java.util.HashMap;
import java.util.Iterator;

public class BundledTileSetRepository
implements TileSetRepository {
    protected ImageManager _imgr;
    protected HashIntMap<TileSet> _idmap;
    protected HashMap<String, Integer> _namemap;

    public BundledTileSetRepository(final ResourceManager rmgr, ImageManager imgr, final String name) {
        this._imgr = imgr;
        new Thread(new Runnable(){

            @Override
            public void run() {
                BundledTileSetRepository.this.initBundles(rmgr, name);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initBundles(ResourceManager rmgr, String name) {
        ResourceBundle[] rbundles = rmgr.getResourceSet(name);
        if (rbundles == null) {
            Log.log.warning((Object)("Unable to fetch tileset resource set [name=" + name + "]. Perhaps it's not defined " + "in the resource manager config?"), new Object[0]);
            return;
        }
        HashIntMap idmap = new HashIntMap();
        HashMap namemap = Maps.newHashMap();
        ResourceBundle[] resourceBundleArray = rbundles;
        int n = rbundles.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceBundle rbundle = resourceBundleArray[n2];
            this.addBundle((HashIntMap<TileSet>)idmap, (HashMap<String, Integer>)namemap, rbundle);
            ++n2;
        }
        BundledTileSetRepository bundledTileSetRepository = this;
        synchronized (bundledTileSetRepository) {
            this._idmap = idmap;
            this._namemap = namemap;
            this.notifyAll();
        }
    }

    public void addBundle(ResourceBundle bundle) {
        this.addBundle(this._idmap, this._namemap, bundle);
    }

    protected void addBundle(HashIntMap<TileSet> idmap, HashMap<String, Integer> namemap, ResourceBundle bundle) {
        try {
            TileSetBundle tsb = BundleUtil.extractBundle(bundle);
            tsb.init(bundle);
            this.addBundle(idmap, namemap, tsb);
        }
        catch (Exception e) {
            Log.log.warning((Object)("Unable to load tileset bundle 'tsbundles.dat' from resource bundle [rbundle=" + bundle + "]."), new Object[]{e});
        }
    }

    protected void addBundle(HashIntMap<TileSet> idmap, HashMap<String, Integer> namemap, TileSetBundle bundle) {
        IMImageProvider improv = this._imgr == null ? null : new IMImageProvider(this._imgr, bundle);
        for (IntMap.IntEntry entry : bundle.intEntrySet()) {
            Integer tsid = (Integer)entry.getKey();
            TileSet tset = (TileSet)entry.getValue();
            tset.setImageProvider(improv);
            idmap.put(tsid.intValue(), (Object)tset);
            namemap.put(tset.getName(), tsid);
        }
    }

    @Override
    public Iterator<Integer> enumerateTileSetIds() throws PersistenceException {
        this.waitForBundles();
        return this._idmap.keySet().iterator();
    }

    @Override
    public Iterator<TileSet> enumerateTileSets() throws PersistenceException {
        this.waitForBundles();
        return this._idmap.values().iterator();
    }

    @Override
    public TileSet getTileSet(int tileSetId) throws NoSuchTileSetException, PersistenceException {
        this.waitForBundles();
        TileSet tset = (TileSet)this._idmap.get(tileSetId);
        if (tset == null) {
            throw new NoSuchTileSetException(tileSetId);
        }
        return tset;
    }

    @Override
    public int getTileSetId(String setName) throws NoSuchTileSetException, PersistenceException {
        this.waitForBundles();
        Integer tsid = this._namemap.get(setName);
        if (tsid != null) {
            return tsid;
        }
        throw new NoSuchTileSetException(setName);
    }

    @Override
    public TileSet getTileSet(String setName) throws NoSuchTileSetException, PersistenceException {
        this.waitForBundles();
        Integer tsid = this._namemap.get(setName);
        if (tsid != null) {
            return this.getTileSet(tsid);
        }
        throw new NoSuchTileSetException(setName);
    }

    protected synchronized void waitForBundles() {
        while (this._idmap == null) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                Log.log.warning((Object)("Interrupted waiting for bundles " + ie), new Object[0]);
            }
        }
    }
}

