/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.animation;

import com.threerings.media.animation.Animation;
import com.threerings.media.image.Mirage;
import com.threerings.media.util.LinearTimeFunction;
import com.threerings.media.util.TimeFunction;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class ScaleAnimation
extends Animation {
    protected Mirage _image;
    protected BufferedImage _bufferedImage;
    protected Point _center;
    protected float _startScale;
    protected float _endScale;
    protected float _scale;
    protected TimeFunction _scaleFunc;

    public ScaleAnimation(Mirage image, Point center, float startScale, float endScale, int duration) {
        super(ScaleAnimation.getBounds(Math.max(startScale, endScale), center, image));
        this._image = image;
        this._bufferedImage = this._image.getSnapshot();
        this._center = new Point(center);
        this._startScale = startScale;
        this._endScale = endScale;
        this._scaleFunc = new LinearTimeFunction(0, 10000, duration);
    }

    public static Rectangle getBounds(float scale, Point center, Mirage image) {
        Point size = ScaleAnimation.getSize(scale, image);
        Point corner = ScaleAnimation.getCorner(center, size);
        return new Rectangle(corner.x, corner.y, size.x, size.y);
    }

    @Override
    public Rectangle getBounds() {
        return ScaleAnimation.getBounds(this._scale, this._center, this._image);
    }

    public static Point getSize(float scale, Mirage image) {
        int width = Math.max(0, Math.round((float)image.getWidth() * scale));
        int height = Math.max(0, Math.round((float)image.getHeight() * scale));
        return new Point(width, height);
    }

    public static Point getCorner(Point center, Point size) {
        return new Point(center.x - size.x / 2, center.y - size.y / 2);
    }

    @Override
    public void tick(long tickStamp) {
        float weight = (float)this._scaleFunc.getValue(tickStamp) / 10000.0f;
        float scale = (1.0f - weight) * this._startScale + weight * this._endScale;
        if (this._scale != scale) {
            this._scale = scale;
            this.invalidate();
        }
        if (weight >= 1.0f) {
            this._finished = true;
        }
    }

    @Override
    public void fastForward(long timeDelta) {
        this._scaleFunc.fastForward(timeDelta);
    }

    @Override
    public void paint(Graphics2D gfx) {
        Rectangle bounds = this.getBounds();
        if (bounds.width <= 0 || bounds.height <= 0) {
            return;
        }
        gfx.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        gfx.drawImage(this._bufferedImage, bounds.x, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height, 0, 0, this._bufferedImage.getWidth(), this._bufferedImage.getHeight(), null);
    }
}

