/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.animation;

import com.samskivert.util.SortableArrayList;
import com.threerings.media.AbstractMedia;
import com.threerings.media.AbstractMediaManager;
import com.threerings.media.animation.Animation;
import java.util.Iterator;

public class AnimationManager
extends AbstractMediaManager
implements Iterable<Animation> {
    protected SortableArrayList<Animation> _anims;

    public void registerAnimation(Animation anim) {
        this.insertMedia(anim);
    }

    public void unregisterAnimation(Animation anim) {
        this.removeMedia(anim);
    }

    @Override
    public Iterator<Animation> iterator() {
        return this._anims.iterator();
    }

    @Override
    protected void tickAllMedia(long tickStamp) {
        super.tickAllMedia(tickStamp);
        int ii = this._anims.size() - 1;
        while (ii >= 0) {
            Animation anim = (Animation)this._anims.get(ii);
            if (anim.isFinished()) {
                anim.willFinish(tickStamp);
                this.unregisterAnimation(anim);
                anim.didFinish(tickStamp);
            }
            --ii;
        }
    }

    @Override
    protected SortableArrayList<? extends AbstractMedia> createMediaList() {
        this._anims = new SortableArrayList();
        return this._anims;
    }
}

