/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media;

import com.google.common.collect.Iterators;
import com.samskivert.swing.Label;
import com.samskivert.util.IntListUtil;
import com.samskivert.util.StringUtil;
import com.threerings.media.AbstractMedia;
import com.threerings.media.FrameManager;
import com.threerings.media.Log;
import com.threerings.media.MediaConstants;
import com.threerings.media.MediaHost;
import com.threerings.media.RegionManager;
import com.threerings.media.animation.Animation;
import com.threerings.media.animation.AnimationManager;
import com.threerings.media.sprite.Sprite;
import com.threerings.media.sprite.SpriteManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Iterator;

public class MetaMediaManager
implements MediaConstants,
Iterable<AbstractMedia> {
    protected FrameManager _framemgr;
    protected MediaHost _host;
    protected RegionManager _remgr = new RegionManager();
    protected AnimationManager _animmgr = new AnimationManager();
    protected SpriteManager _spritemgr = new SpriteManager();
    protected boolean _paused;
    protected long _pauseTime;
    protected int[] _dirty = new int[200];
    protected int _tick;
    protected float _dirtyPerTick;
    protected String _perfStatus = "";
    protected Label _perfLabel;
    protected Rectangle _perfRect;

    public MetaMediaManager(FrameManager framemgr, MediaHost host) {
        this._framemgr = framemgr;
        this._host = host;
        this._animmgr.init(host, this._remgr);
        this._spritemgr.init(host, this._remgr);
    }

    public FrameManager getFrameManager() {
        return this._framemgr;
    }

    public AnimationManager getAnimationManager() {
        return this._animmgr;
    }

    public SpriteManager getSpriteManager() {
        return this._spritemgr;
    }

    public RegionManager getRegionManager() {
        return this._remgr;
    }

    public boolean isPaused() {
        return this._paused;
    }

    public void setPaused(boolean paused) {
        if (paused && this._pauseTime != 0L || !paused && this._pauseTime == 0L) {
            Log.log.warning((Object)"Requested to pause when paused or vice-versa", new Object[]{"paused", paused});
            return;
        }
        this._paused = paused;
        if (this._paused) {
            this._pauseTime = this._framemgr.getTimeStamp();
        } else {
            long delta = this._framemgr.getTimeStamp() - this._pauseTime;
            this._animmgr.fastForward(delta);
            this._spritemgr.fastForward(delta);
            this._pauseTime = 0L;
        }
    }

    public long getTimeStamp() {
        return this._framemgr.getTimeStamp();
    }

    public void addSprite(Sprite sprite) {
        this._spritemgr.addSprite(sprite);
    }

    public boolean isManaged(Sprite sprite) {
        return this._spritemgr.isManaged(sprite);
    }

    public void removeSprite(Sprite sprite) {
        this._spritemgr.removeSprite(sprite);
    }

    public void clearSprites() {
        this._spritemgr.clearMedia();
    }

    public void addAnimation(Animation anim) {
        this._animmgr.registerAnimation(anim);
    }

    public boolean isManaged(Animation anim) {
        return this._animmgr.isManaged(anim);
    }

    public void abortAnimation(Animation anim) {
        this._animmgr.unregisterAnimation(anim);
    }

    public void clearAnimations() {
        this._animmgr.clearMedia();
    }

    public void noteDirty(int regions) {
        this._dirty[this._tick] = regions;
    }

    public void tick(long tickStamp) {
        this._animmgr.tick(tickStamp);
        this._spritemgr.tick(tickStamp);
        if (FrameManager._perfDebug.getValue()) {
            if (this._perfLabel == null) {
                this._perfLabel = new Label("", 2, Color.white, Color.black, new Font("Arial", 0, 10));
            }
            if (this._perfRect == null) {
                this._perfRect = new Rectangle(5, 5, 0, 0);
            }
            StringBuilder perf = new StringBuilder();
            perf.append("[FPS: ");
            perf.append(this._framemgr.getPerfTicks()).append("/");
            perf.append(this._framemgr.getPerfTries());
            perf.append(" PM:");
            StringUtil.toString((StringBuilder)perf, (Object)this._framemgr.getPerfMetrics());
            perf.append("]");
            String perfStatus = perf.toString();
            if (!this._perfStatus.equals(perfStatus)) {
                this._perfStatus = perfStatus;
                this._perfLabel.setText(perfStatus);
                Graphics2D gfx = this._host.createGraphics();
                if (gfx != null) {
                    this._perfLabel.layout(gfx);
                    gfx.dispose();
                    Dimension psize = this._perfLabel.getSize();
                    this._perfRect.width = Math.max(this._perfRect.width, psize.width);
                    this._perfRect.height = Math.max(this._perfRect.height, psize.height);
                    this._remgr.addDirtyRegion(new Rectangle(this._perfRect));
                }
            }
        } else {
            this._perfRect = null;
        }
    }

    public boolean needsPaint() {
        if (this._tick++ == 99) {
            this._tick = 0;
            int dirty = IntListUtil.sum((int[])this._dirty);
            Arrays.fill(this._dirty, 0);
            this._dirtyPerTick = (float)dirty / 100.0f;
        }
        this._animmgr.willPaint();
        this._spritemgr.willPaint();
        return this._remgr.haveDirtyRegions();
    }

    public void paintMedia(Graphics2D gfx, int layer, Rectangle dirty) {
        if (layer == 2) {
            this._spritemgr.paint(gfx, layer, dirty);
            this._animmgr.paint(gfx, layer, dirty);
        } else {
            this._animmgr.paint(gfx, layer, dirty);
            this._spritemgr.paint(gfx, layer, dirty);
        }
    }

    public void paintPerf(Graphics2D gfx) {
        if (this._perfRect != null && FrameManager._perfDebug.getValue()) {
            gfx.setClip(null);
            this._perfLabel.render(gfx, (float)this._perfRect.x, (float)this._perfRect.y);
        }
    }

    public void viewLocationDidChange(int dx, int dy) {
        if (this._perfRect != null) {
            Rectangle sdirty = new Rectangle(this._perfRect);
            sdirty.translate(-dx, -dy);
            this._remgr.addDirtyRegion(sdirty);
        }
        this._animmgr.viewLocationDidChange(dx, dy);
        this._spritemgr.viewLocationDidChange(dx, dy);
    }

    @Override
    public Iterator<AbstractMedia> iterator() {
        return Iterators.concat(this._spritemgr.enumerateSprites(), this._animmgr.iterator());
    }
}

