/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast;

import com.threerings.cast.CompositedActionFrames;
import com.threerings.cast.CompositedMirage;
import com.threerings.cast.TrimmedMultiFrameImage;
import com.threerings.cast.bundle.BundledComponentRepository;
import com.threerings.media.image.ImageManager;
import com.threerings.media.image.Mirage;
import com.threerings.media.image.VolatileMirage;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Comparator;

public class CompositedMultiFrameImage
implements TrimmedMultiFrameImage {
    protected ImageManager _imgr;
    protected CompositedActionFrames.ComponentFrames[] _sources;
    protected String _action;
    protected int _orient;
    protected CompositedMirage[] _images;

    public CompositedMultiFrameImage(ImageManager imgr, CompositedActionFrames.ComponentFrames[] sources, String action, int orient) {
        this._imgr = imgr;
        this._sources = sources;
        this._action = action;
        this._orient = orient;
        int fcount = sources[0].frames.getFrames(orient).getFrameCount();
        this._images = new CompositedMirage[fcount];
        int ii = 0;
        while (ii < fcount) {
            this._images[ii] = this.createCompositedMirage(ii);
            ++ii;
        }
    }

    @Override
    public int getFrameCount() {
        return this._images.length;
    }

    @Override
    public int getWidth(int index) {
        return this._images[index].getWidth();
    }

    @Override
    public int getHeight(int index) {
        return this._images[index].getHeight();
    }

    public int getXOrigin(int index) {
        return this._images[index].getXOrigin();
    }

    public int getYOrigin(int index) {
        return this._images[index].getYOrigin();
    }

    @Override
    public void paintFrame(Graphics2D g, int index, int x, int y) {
        this._images[index].paint(g, x, y);
    }

    @Override
    public boolean hitTest(int index, int x, int y) {
        return this._images[index].hitTest(x, y);
    }

    @Override
    public void getTrimmedBounds(int index, Rectangle bounds) {
        bounds.setBounds(0, 0, this.getWidth(index), this.getHeight(index));
    }

    public long getEstimatedMemoryUsage() {
        long size = 0L;
        CompositedMirage[] compositedMirageArray = this._images;
        int n = this._images.length;
        int n2 = 0;
        while (n2 < n) {
            CompositedMirage element = compositedMirageArray[n2];
            size += element.getEstimatedMemoryUsage();
            ++n2;
        }
        return size;
    }

    protected CompositedMirage createCompositedMirage(int index) {
        if (this._sources.length == 1 && this._sources[0].frames instanceof BundledComponentRepository.TileSetFrameImage) {
            BundledComponentRepository.TileSetFrameImage frames = (BundledComponentRepository.TileSetFrameImage)this._sources[0].frames;
            Rectangle tbounds = new Rectangle();
            frames.getTrimmedBounds(this._orient, index, tbounds);
            int x = frames.getXOrigin(this._orient, index) - tbounds.x;
            int y = frames.getYOrigin(this._orient, index) - tbounds.y;
            return new SubmirageForwarder(frames.getTileMirage(this._orient, index), x, y);
        }
        return new CompositedVolatileMirage(index);
    }

    protected Mirage getFrame(int orient, int index) {
        return this._images[index];
    }

    protected class CompositedVolatileMirage
    extends VolatileMirage
    implements CompositedMirage,
    Comparator<CompositedActionFrames.ComponentFrames> {
        protected int _index;
        protected Point _origin;

        public CompositedVolatileMirage(int index) {
            super(CompositedMultiFrameImage.this._imgr, new Rectangle(0, 0, 0, 0));
            this._origin = new Point();
            this._index = index;
            Rectangle tbounds = new Rectangle();
            int scount = CompositedMultiFrameImage.this._sources.length;
            int ii = 0;
            while (ii < scount) {
                TrimmedMultiFrameImage source = CompositedMultiFrameImage.this._sources[ii].frames.getFrames(CompositedMultiFrameImage.this._orient);
                source.getTrimmedBounds(index, tbounds);
                this._bounds = this.combineBounds(this._bounds, tbounds);
                ++ii;
            }
            if (this._bounds.width <= 0) {
                this._bounds.width = 1;
            }
            if (this._bounds.height <= 0) {
                this._bounds.height = 1;
            }
            this._origin.x = CompositedMultiFrameImage.this._sources[0].frames.getXOrigin(CompositedMultiFrameImage.this._orient, index) - this._bounds.x;
            this._origin.y = CompositedMultiFrameImage.this._sources[0].frames.getYOrigin(CompositedMultiFrameImage.this._orient, index) - this._bounds.y;
            this.createVolatileImage();
        }

        @Override
        public int getXOrigin() {
            return this._origin.x;
        }

        @Override
        public int getYOrigin() {
            return this._origin.y;
        }

        @Override
        public int compare(CompositedActionFrames.ComponentFrames cf1, CompositedActionFrames.ComponentFrames cf2) {
            return cf1.ccomp.getRenderPriority(CompositedMultiFrameImage.this._action, CompositedMultiFrameImage.this._orient) - cf2.ccomp.getRenderPriority(CompositedMultiFrameImage.this._action, CompositedMultiFrameImage.this._orient);
        }

        protected Rectangle combineBounds(Rectangle bounds, Rectangle tbounds) {
            if (bounds.width == 0 && bounds.height == 0) {
                bounds.setBounds(tbounds);
            } else {
                bounds.add(tbounds);
            }
            return bounds;
        }

        @Override
        protected int getTransparency() {
            return 2;
        }

        @Override
        protected void refreshVolatileImage() {
            Arrays.sort(CompositedMultiFrameImage.this._sources, this);
            int scount = CompositedMultiFrameImage.this._sources.length;
            Graphics2D g = (Graphics2D)this._image.getGraphics();
            try {
                int ii = 0;
                while (ii < scount) {
                    TrimmedMultiFrameImage source = CompositedMultiFrameImage.this._sources[ii].frames.getFrames(CompositedMultiFrameImage.this._orient);
                    source.paintFrame(g, this._index, -this._bounds.x, -this._bounds.y);
                    ++ii;
                }
            }
            finally {
                if (g != null) {
                    g.dispose();
                }
            }
        }
    }

    protected class SubmirageForwarder
    implements CompositedMirage {
        protected int x;
        protected int y;
        protected Mirage delegate;

        public SubmirageForwarder(Mirage m, int x, int y) {
            this.delegate = m;
            this.x = x;
            this.y = y;
        }

        @Override
        public int getXOrigin() {
            return this.x;
        }

        @Override
        public int getYOrigin() {
            return this.y;
        }

        @Override
        public long getEstimatedMemoryUsage() {
            return this.delegate.getEstimatedMemoryUsage();
        }

        @Override
        public int getHeight() {
            return this.delegate.getHeight();
        }

        @Override
        public BufferedImage getSnapshot() {
            return this.delegate.getSnapshot();
        }

        @Override
        public int getWidth() {
            return this.delegate.getWidth();
        }

        @Override
        public boolean hitTest(int x, int y) {
            return this.delegate.hitTest(x, y);
        }

        @Override
        public void paint(Graphics2D gfx, int x, int y) {
            this.delegate.paint(gfx, x, y);
        }
    }
}

