/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.miso.data;

import com.samskivert.util.ArrayUtil;
import com.samskivert.util.ListUtil;
import com.samskivert.util.StringUtil;
import com.threerings.io.SimpleStreamableObject;
import com.threerings.media.util.MathUtil;
import com.threerings.miso.Log;
import com.threerings.miso.data.MisoSceneModel;
import com.threerings.miso.data.ObjectInfo;
import com.threerings.miso.util.ObjectSet;
import com.threerings.util.StreamableHashMap;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;

public class SparseMisoSceneModel
extends MisoSceneModel {
    public short swidth;
    public short sheight;
    public int defTileSet = 0;
    protected StreamableHashMap<Integer, Section> _sections = StreamableHashMap.newMap();

    public SparseMisoSceneModel(int swidth, int sheight) {
        this.swidth = (short)swidth;
        this.sheight = (short)sheight;
    }

    public SparseMisoSceneModel() {
    }

    public void getInterestingObjects(ArrayList<ObjectInfo> list) {
        Iterator<Section> iter = this.getSections();
        while (iter.hasNext()) {
            Section sect = iter.next();
            for (ObjectInfo element : sect.objectInfo) {
                list.add(element);
            }
        }
    }

    public void getAllObjects(ArrayList<ObjectInfo> list) {
        Iterator<Section> iter = this.getSections();
        while (iter.hasNext()) {
            iter.next().getAllObjects(list);
        }
    }

    public void visitObjects(ObjectVisitor visitor) {
        this.visitObjects(visitor, false);
    }

    public void visitObjects(ObjectVisitor visitor, boolean interestingOnly) {
        Iterator<Section> iter = this.getSections();
        while (iter.hasNext()) {
            Section sect = iter.next();
            for (ObjectInfo oinfo : sect.objectInfo) {
                visitor.visit(oinfo);
            }
            if (interestingOnly) continue;
            for (int oo = 0; oo < sect.objectTileIds.length; ++oo) {
                ObjectInfo info = new ObjectInfo();
                info.tileId = sect.objectTileIds[oo];
                info.x = sect.objectXs[oo];
                info.y = sect.objectYs[oo];
                visitor.visit(info);
            }
        }
    }

    @Override
    public int getBaseTileId(int col, int row) {
        Section sec = this.getSection(col, row, false);
        return sec == null ? -1 : sec.getBaseTileId(col, row);
    }

    @Override
    public boolean setBaseTile(int fqBaseTileId, int col, int row) {
        this.getSection(col, row, true).setBaseTile(col, row, fqBaseTileId);
        return true;
    }

    @Override
    public void setDefaultBaseTileSet(int tileSetId) {
        this.defTileSet = tileSetId;
    }

    @Override
    public int getDefaultBaseTileSet() {
        return this.defTileSet;
    }

    @Override
    public void getObjects(Rectangle region, ObjectSet set) {
        int minx = MathUtil.floorDiv(region.x, this.swidth) * this.swidth;
        int maxx = MathUtil.floorDiv(region.x + region.width - 1, this.swidth) * this.swidth;
        int miny = MathUtil.floorDiv(region.y, this.sheight) * this.sheight;
        int maxy = MathUtil.floorDiv(region.y + region.height - 1, this.sheight) * this.sheight;
        for (int yy = miny; yy <= maxy; yy += this.sheight) {
            for (int xx = minx; xx <= maxx; xx += this.swidth) {
                Section sec = this.getSection(xx, yy, false);
                if (sec == null) continue;
                sec.getObjects(region, set);
            }
        }
    }

    @Override
    public boolean addObject(ObjectInfo info) {
        return this.getSection(info.x, info.y, true).addObject(info);
    }

    @Override
    public void updateObject(ObjectInfo info) {
        this.removeObject(info);
        this.addObject(info);
    }

    @Override
    public boolean removeObject(ObjectInfo info) {
        Section sec = this.getSection(info.x, info.y, false);
        if (sec != null) {
            return sec.removeObject(info);
        }
        return false;
    }

    public void setSection(Section section) {
        this._sections.put((Object)this.key(section.x, section.y), (Object)section);
    }

    public Iterator<Section> getSections() {
        return this._sections.values().iterator();
    }

    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", sections=" + StringUtil.toString(this._sections.values().iterator()));
    }

    protected final int key(int x, int y) {
        int sx = MathUtil.floorDiv(x, this.swidth);
        int sy = MathUtil.floorDiv(y, this.sheight);
        return sx << 16 | sy & 0xFFFF;
    }

    protected final Section getSection(int x, int y, boolean create) {
        int key = this.key(x, y);
        Section sect = (Section)this._sections.get((Object)key);
        if (sect == null && create) {
            short sx = (short)(MathUtil.floorDiv(x, this.swidth) * this.swidth);
            short sy = (short)(MathUtil.floorDiv(y, this.sheight) * this.sheight);
            sect = new Section(sx, sy, this.swidth, this.sheight);
            this._sections.put((Object)key, (Object)sect);
        }
        return sect;
    }

    @Override
    public SparseMisoSceneModel clone() {
        SparseMisoSceneModel model = (SparseMisoSceneModel)super.clone();
        model._sections = StreamableHashMap.newMap();
        Iterator<Section> iter = this.getSections();
        while (iter.hasNext()) {
            Section sect = iter.next();
            model.setSection(sect.clone());
        }
        return model;
    }

    public static class Section
    extends SimpleStreamableObject
    implements Cloneable {
        public short x;
        public short y;
        public int width;
        public int[] baseTileIds;
        public int[] objectTileIds = new int[0];
        public short[] objectXs = new short[0];
        public short[] objectYs = new short[0];
        public ObjectInfo[] objectInfo = new ObjectInfo[0];

        public Section() {
        }

        public Section(short x, short y, short width, short height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.baseTileIds = new int[width * height];
        }

        public int getBaseTileId(int col, int row) {
            if (col < this.x || col >= this.x + this.width || row < this.y || row >= this.y + this.width) {
                Log.log.warning((Object)("Requested bogus tile +" + col + "+" + row + " from " + this + "."), new Object[0]);
                return -1;
            }
            return this.baseTileIds[(row - this.y) * this.width + (col - this.x)];
        }

        public void setBaseTile(int col, int row, int fqBaseTileId) {
            this.baseTileIds[(row - this.y) * this.width + (col - this.x)] = fqBaseTileId;
        }

        public boolean addObject(ObjectInfo info) {
            int dupidx = ListUtil.indexOf((Object[])this.objectInfo, (Object)info);
            if (dupidx != -1) {
                Log.log.warning((Object)("Refusing to add duplicate object [ninfo=" + info + ", oinfo=" + this.objectInfo[dupidx] + "]."), new Object[0]);
                return false;
            }
            dupidx = this.indexOfUn(info);
            if (dupidx != -1) {
                Log.log.warning((Object)("Refusing to add duplicate object [info=" + info + "]."), new Object[0]);
                return false;
            }
            if (info.isInteresting()) {
                this.objectInfo = (ObjectInfo[])ArrayUtil.append((Object[])this.objectInfo, (Object)info);
            } else {
                this.objectTileIds = ArrayUtil.append((int[])this.objectTileIds, (int)info.tileId);
                this.objectXs = ArrayUtil.append((short[])this.objectXs, (short)((short)info.x));
                this.objectYs = ArrayUtil.append((short[])this.objectYs, (short)((short)info.y));
            }
            return true;
        }

        public boolean removeObject(ObjectInfo info) {
            int oidx = ListUtil.indexOf((Object[])this.objectInfo, (Object)info);
            if (oidx != -1) {
                this.objectInfo = (ObjectInfo[])ArrayUtil.splice((Object[])this.objectInfo, (int)oidx, (int)1);
                return true;
            }
            oidx = this.indexOfUn(info);
            if (oidx != -1) {
                this.objectTileIds = ArrayUtil.splice((int[])this.objectTileIds, (int)oidx, (int)1);
                this.objectXs = ArrayUtil.splice((short[])this.objectXs, (int)oidx, (int)1);
                this.objectYs = ArrayUtil.splice((short[])this.objectYs, (int)oidx, (int)1);
                return true;
            }
            return false;
        }

        protected int indexOfUn(ObjectInfo info) {
            for (int ii = 0; ii < this.objectTileIds.length; ++ii) {
                if (this.objectTileIds[ii] != info.tileId || this.objectXs[ii] != info.x || this.objectYs[ii] != info.y) continue;
                return ii;
            }
            return -1;
        }

        public void getAllObjects(ArrayList<ObjectInfo> list) {
            for (ObjectInfo info : this.objectInfo) {
                list.add(info);
            }
            for (int ii = 0; ii < this.objectTileIds.length; ++ii) {
                short x = this.objectXs[ii];
                short y = this.objectYs[ii];
                list.add(new ObjectInfo(this.objectTileIds[ii], x, y));
            }
        }

        public void getObjects(Rectangle region, ObjectSet set) {
            for (ObjectInfo info : this.objectInfo) {
                if (!region.contains(info.x, info.y)) continue;
                set.insert(info);
            }
            for (int ii = 0; ii < this.objectTileIds.length; ++ii) {
                short x = this.objectXs[ii];
                short y = this.objectYs[ii];
                if (!region.contains(x, y)) continue;
                set.insert(new ObjectInfo(this.objectTileIds[ii], x, y));
            }
        }

        public boolean isBlank() {
            if (this.objectTileIds.length != 0 || this.objectInfo.length != 0) {
                return false;
            }
            for (int baseTileId : this.baseTileIds) {
                if (baseTileId == 0) continue;
                return false;
            }
            return true;
        }

        public Section clone() {
            try {
                Section section = (Section)super.clone();
                section.baseTileIds = (int[])this.baseTileIds.clone();
                section.objectTileIds = (int[])this.objectTileIds.clone();
                section.objectXs = (short[])this.objectXs.clone();
                section.objectYs = (short[])this.objectYs.clone();
                section.objectInfo = new ObjectInfo[this.objectInfo.length];
                for (int ii = 0; ii < this.objectInfo.length; ++ii) {
                    section.objectInfo[ii] = this.objectInfo[ii].clone();
                }
                return section;
            }
            catch (CloneNotSupportedException cnse) {
                throw new AssertionError((Object)cnse);
            }
        }

        public String toString() {
            if (this.width == 0 || this.baseTileIds == null) {
                return "<no bounds>";
            }
            return String.format("%sx%s+%s:%s:%s", this.width, this.baseTileIds.length / this.width, this.x, this.y, this.objectInfo.length, this.objectTileIds.length);
        }
    }

    public static interface ObjectVisitor {
        public void visit(ObjectInfo var1);
    }
}

