/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media.tile;

import com.threerings.geom.GeomUtil;
import com.threerings.media.tile.TileSet;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class UniformTileSet
extends TileSet {
    protected int _width;
    protected int _height;
    private static final long serialVersionUID = 3536616655149232917L;

    @Override
    public int getTileCount() {
        BufferedImage tsimg = this.getRawTileSetImage();
        int perRow = tsimg.getWidth() / this._width;
        int perCol = tsimg.getHeight() / this._height;
        return perRow * perCol;
    }

    @Override
    public Rectangle computeTileBounds(int tileIndex, Rectangle bounds) {
        BufferedImage tsimg = this.getRawTileSetImage();
        GeomUtil.getTile(tsimg.getWidth(), tsimg.getHeight(), this._width, this._height, tileIndex, bounds);
        return bounds;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public int getWidth() {
        return this._width;
    }

    public void setHeight(int height) {
        this._height = height;
    }

    public int getHeight() {
        return this._height;
    }

    @Override
    protected void toString(StringBuilder buf) {
        super.toString(buf);
        buf.append(", width=").append(this._width);
        buf.append(", height=").append(this._height);
    }
}

