/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media;

import com.samskivert.util.ResultListener;
import com.threerings.media.FrameManager;
import com.threerings.media.FrameParticipant;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;

public class TimerView
implements FrameParticipant,
HierarchyListener {
    protected FrameManager _fmgr;
    protected JComponent _host;
    protected Rectangle _bounds;
    protected boolean _enabled = true;
    protected boolean _running = false;
    protected boolean _participating = false;
    protected long _lastUpdate = Long.MIN_VALUE;
    protected long _duration;
    protected long _start;
    protected float _complete = 0.0f;
    protected float _renderOffset = 0.0f;
    protected long _renderOffsetTime = Long.MIN_VALUE;
    protected long _transitionTime = 0L;
    protected float _renderComplete = 0.0f;
    protected float _paintComplete = -1.0f;
    protected float _changeThreshold = 0.0f;
    protected boolean _invalidated;
    protected float _warnPercent = -1.0f;
    protected boolean _warned;
    protected boolean _completed;
    protected boolean _processUnpause = false;
    protected ResultListener<TimerView> _finisher;
    protected ResultListener<TimerView> _warner;
    protected static final long DEFAULT_RATE = 100L;

    public TimerView(FrameManager fmgr, JComponent host, Rectangle bounds) {
        this._fmgr = fmgr;
        this._host = host;
        this._bounds = new Rectangle(bounds);
        this._host.addHierarchyListener(this);
        this.checkFrameParticipation();
    }

    public void setEnabled(boolean enabled) {
        if (this._enabled != enabled) {
            this._enabled = enabled;
            this.invalidate();
        }
    }

    public long getTransitionTime() {
        return this._transitionTime;
    }

    public void setTransitionTime(long time) {
        this._transitionTime = Math.max(0L, time);
    }

    public void setWarning(float warnPercent, ResultListener<TimerView> warner) {
        this._warned = false;
        this._warnPercent = warnPercent;
        this._warner = warner;
    }

    public void removeWarning() {
        this._warned = false;
        this._warnPercent = -1.0f;
        this._warner = null;
    }

    public boolean running() {
        return this._running;
    }

    public void start(float startPercent, long duration, ResultListener<TimerView> finisher) {
        if (startPercent < 0.0f || startPercent >= 1.0f) {
            throw new IllegalArgumentException("Invalid starting percent " + startPercent);
        }
        if (duration < 0L) {
            throw new IllegalArgumentException("Invalid duration " + duration);
        }
        this.stop();
        this._duration = duration;
        this.changeComplete(startPercent);
        this._start = Long.MIN_VALUE;
        this._finisher = finisher;
        this._warned = false;
        this._completed = false;
        this._running = true;
    }

    public void reset() {
        this.stop();
        this.changeComplete(0.0f);
    }

    public void stop() {
        this.pause();
        this._lastUpdate = Long.MIN_VALUE;
    }

    public void pause() {
        this._running = false;
    }

    public void unpause() {
        if (this._lastUpdate == Long.MIN_VALUE || this._start == Long.MIN_VALUE) {
            return;
        }
        this._processUnpause = true;
        this._running = true;
    }

    public void changeComplete(float complete) {
        this._complete = complete;
        this._renderOffset = this._renderComplete - this._complete;
        this._renderOffsetTime = Long.MIN_VALUE;
    }

    protected void update(long now) {
    }

    protected boolean triggeredWarning() {
        return this._warnPercent >= 0.0f && !this._warned && this._warnPercent <= this._complete;
    }

    protected boolean triggeredCompleted() {
        return !this._completed && 1.0 <= (double)this._complete;
    }

    protected void handleWarning() {
        this._warned = true;
        if (this._warner != null) {
            this._warner.requestCompleted((Object)this);
        }
    }

    protected void handleCompleted() {
        this._completed = true;
        this.stop();
        if (this._finisher != null) {
            this._finisher.requestCompleted((Object)this);
        }
    }

    protected void invalidate() {
        this._invalidated = true;
        this._host.repaint(this._bounds.x, this._bounds.y, this._bounds.width, this._bounds.height);
    }

    public void render(Graphics2D gfx) {
        if (this._enabled) {
            this.paint(gfx, this._renderComplete);
        }
        this._invalidated = false;
    }

    public void paint(Graphics2D gfx, float complete) {
        this._paintComplete = complete;
    }

    @Override
    public void tick(long now) {
        if (!this._enabled) {
            return;
        }
        if (this._start == Long.MIN_VALUE) {
            this._start = now - (long)Math.round((float)this._duration * this._complete);
        }
        if (this._renderOffsetTime == Long.MIN_VALUE) {
            this._renderOffsetTime = now;
        }
        if (this._processUnpause) {
            this._processUnpause = false;
            this._start += now - this._lastUpdate;
        }
        if (this.running()) {
            this._lastUpdate = now;
            this._complete = (float)(this._lastUpdate - this._start) / (float)this._duration;
            if (this.triggeredWarning()) {
                this.handleWarning();
            }
            if (this.triggeredCompleted()) {
                this.handleCompleted();
            }
        }
        this._renderComplete = this._complete;
        if (this._renderOffsetTime + this._transitionTime > now) {
            this._renderComplete += this._renderOffset * (1.0f - (float)(now - this._renderOffsetTime) / (float)this._transitionTime);
            this._renderComplete = Math.max(0.0f, Math.min(1.0f, this._renderComplete));
        }
        if (this._renderComplete != this._paintComplete) {
            if (this._renderComplete <= 0.0f || this._paintComplete <= 0.0f || this._renderComplete >= 1.0f || this._paintComplete >= 1.0f) {
                this.invalidate();
            } else if (Math.abs(this._renderComplete - this._paintComplete) > this._changeThreshold) {
                this.invalidate();
            }
        }
    }

    @Override
    public boolean needsPaint() {
        return this._invalidated;
    }

    @Override
    public Component getComponent() {
        return null;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        this.checkFrameParticipation();
    }

    public void checkFrameParticipation() {
        boolean participate = this._host.isShowing();
        if (participate && !this._participating) {
            this._fmgr.registerFrameParticipant(this);
            this._participating = true;
        } else if (!participate && this._participating) {
            this._fmgr.removeFrameParticipant(this);
            this._participating = false;
        }
    }
}

