/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.media;

import com.threerings.media.FrameManager;
import com.threerings.media.Log;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Graphics2D;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.image.BufferStrategy;

public class FlipFrameManager
extends FrameManager {
    protected BufferStrategy _bufstrat;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paint(long tickStamp) {
        if (this._bufstrat == null) {
            BufferCapabilities cap = new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), BufferCapabilities.FlipContents.COPIED);
            try {
                this._window.createBufferStrategy(2, cap);
            }
            catch (AWTException ae) {
                Log.log.warning((Object)("Failed creating flip bufstrat: " + ae + "."), new Object[0]);
                this._window.createBufferStrategy(2);
            }
            this._bufstrat = this._window.getBufferStrategy();
        }
        boolean incremental = true;
        do {
            Graphics2D gfx = null;
            try {
                gfx = (Graphics2D)this._bufstrat.getDrawGraphics();
                if (!incremental) {
                    Log.log.info((Object)"Doing non-incremental render; contents lost", new Object[]{"lost", this._bufstrat.contentsLost(), "rest", this._bufstrat.contentsRestored()});
                    this._root.getRootPane().revalidate();
                    this._root.getRootPane().repaint();
                }
                if (!this.paint(gfx)) {
                    return;
                }
                this._bufstrat.show();
                incremental = false;
            }
            finally {
                if (gfx != null) {
                    gfx.dispose();
                }
            }
        } while (this._bufstrat.contentsLost());
    }

    @Override
    protected Graphics2D createGraphics() {
        return (Graphics2D)this._bufstrat.getDrawGraphics();
    }

    @Override
    protected void restoreFromBack(Rectangle dirty) {
    }
}

