/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.cast;

import com.threerings.cast.ActionFrames;
import com.threerings.cast.ActionSequence;
import com.threerings.cast.CharacterDescriptor;
import com.threerings.cast.CharacterManager;
import com.threerings.cast.Log;
import com.threerings.cast.NoSuchComponentException;
import com.threerings.cast.StandardActions;
import com.threerings.media.sprite.ImageSprite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class CharacterSprite
extends ImageSprite
implements StandardActions {
    protected String _restingAction = "standing";
    protected String _followingPathAction = "walking";
    protected CharacterDescriptor _descrip;
    protected CharacterManager _charmgr;
    protected String _action;
    protected ActionFrames _aframes;
    protected Point _ioff = new Point();
    protected Rectangle _ibounds = new Rectangle();

    public void init(CharacterDescriptor descrip, CharacterManager charmgr) {
        this._descrip = descrip;
        this._charmgr = charmgr;
        this.sanityCheckDescrip();
        this._orient = 0;
        this.didInit();
    }

    protected void didInit() {
    }

    public void setCharacterDescriptor(CharacterDescriptor descrip) {
        this._descrip = descrip;
        this.sanityCheckDescrip();
        this.updateActionFrames();
    }

    public void setRestingAction(String action) {
        this._restingAction = action;
    }

    public String getRestingAction() {
        return this._restingAction;
    }

    public void setFollowingPathAction(String action) {
        this._followingPathAction = action;
    }

    public String getFollowingPathAction() {
        return this._followingPathAction;
    }

    public void setActionSequence(String action) {
        if (action == null) {
            Log.log.warning((Object)("Refusing to set null action sequence " + this + "."), new Object[]{new Exception()});
            return;
        }
        if (action.equals(this._action)) {
            return;
        }
        this._action = action;
        this.updateActionFrames();
    }

    @Override
    public void setOrientation(int orient) {
        if (orient < 0 || orient >= 16) {
            Log.log.info((Object)"Refusing to set invalid orientation", new Object[]{"sprite", this, "orient", orient, new Exception()});
            return;
        }
        int oorient = this._orient;
        super.setOrientation(orient);
        if (this._orient != oorient) {
            this._frames = null;
        }
    }

    @Override
    public boolean hitTest(int x, int y) {
        return this._frames != null && this._ibounds.contains(x, y) && this._frames.hitTest(this._frameIdx, x - this._ibounds.x, y - this._ibounds.y);
    }

    @Override
    public void tick(long tickStamp) {
        this.compositeActionFrames();
        super.tick(tickStamp);
        this.compositeActionFrames();
    }

    @Override
    public void cancelMove() {
        super.cancelMove();
        this.halt();
    }

    @Override
    public void pathBeginning() {
        super.pathBeginning();
        this.setAnimationMode(2);
        this.setActionSequence(this.getFollowingPathAction());
    }

    @Override
    public void pathCompleted(long timestamp) {
        super.pathCompleted(timestamp);
        this.halt();
    }

    @Override
    public void paint(Graphics2D gfx) {
        if (this._frames != null) {
            this.decorateBehind(gfx);
            this._frames.paintFrame(gfx, this._frameIdx, this._ibounds.x, this._ibounds.y);
            this.decorateInFront(gfx);
        } else {
            super.paint(gfx);
        }
    }

    protected void decorateBehind(Graphics2D gfx) {
    }

    protected void decorateInFront(Graphics2D gfx) {
    }

    protected void updateActionFrames() {
        ActionSequence actseq = this._charmgr.getActionSequence(this._action);
        if (actseq == null) {
            String errmsg = "No such action '" + this._action + "'.";
            throw new IllegalArgumentException(errmsg);
        }
        try {
            this._aframes = this._charmgr.getActionFrames(this._descrip, this._action);
            this._frames = null;
            this.setFrameRate(actseq.framesPerSecond);
        }
        catch (NoSuchComponentException nsce) {
            Log.log.warning((Object)"Character sprite references non-existent component", new Object[]{"sprite", this, "err", nsce});
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed to obtain action frames", new Object[]{"sprite", this, "descrip", this._descrip, "action", this._action, e});
        }
    }

    protected final void compositeActionFrames() {
        if (this._frames == null && this._aframes != null) {
            this.setFrames(this._aframes.getFrames(this._orient));
        }
    }

    protected void sanityCheckDescrip() {
        if (this._descrip.getComponentIds() == null || this._descrip.getComponentIds().length == 0) {
            Log.log.warning((Object)("Invalid character descriptor [sprite=" + this + ", descrip=" + this._descrip + "]."), new Object[]{new Exception()});
        }
    }

    @Override
    protected boolean tickPath(long tickStamp) {
        boolean moved = super.tickPath(tickStamp);
        this.compositeActionFrames();
        return moved;
    }

    @Override
    protected void updateRenderOrigin() {
        super.updateRenderOrigin();
        this._ibounds.x = this._bounds.x + this._ioff.x;
        this._ibounds.y = this._bounds.y + this._ioff.y;
    }

    @Override
    protected void accomodateFrame(int frameIdx, int width, int height) {
        super.accomodateFrame(frameIdx, width, height);
        if (this._aframes == null) {
            Log.log.warning((Object)("Have no action frames! " + this._aframes + "."), new Object[0]);
        } else {
            this._oxoff = this._aframes.getXOrigin(this._orient, frameIdx);
            this._oyoff = this._aframes.getYOrigin(this._orient, frameIdx);
        }
        this.updateRenderOrigin();
        this._ibounds.setBounds(this._bounds);
        this.unionDecorationBounds(this._bounds);
        this._oxoff = this._ox - this._bounds.x;
        this._oyoff = this._oy - this._bounds.y;
        this._ioff.x = this._ibounds.x - this._bounds.x;
        this._ioff.y = this._ibounds.y - this._bounds.y;
    }

    protected void unionDecorationBounds(Rectangle bounds) {
    }

    protected void halt() {
        if (this._animMode != 0) {
            this.setAnimationMode(0);
            String rest = this.getRestingAction();
            if (rest != null) {
                this.setActionSequence(rest);
            }
        }
    }
}

